/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemQueryBuilder;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ClassEntry;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ColumnInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.IItemResultSet;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ItemResultSetException;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ItemResultSetFactory;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ClassLeakingRule
implements IRule {
    private static final String RESULT_ID = "ClassLeak";
    private static final String COUNT_AGGREGATOR_ID = "count";
    public static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("classLeaking.warning.limit", Messages.getString("ClassLeakingRule_CONFIG_WARNING_LIMIT"), Messages.getString("ClassLeakingRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(25L));
    public static final TypedPreference<IQuantity> MAX_NUMBER_OF_CLASSES_TO_REPORT = new TypedPreference("classLeaking.classesToReport.limit", Messages.getString("General_CONFIG_CLASS_LIMIT"), Messages.getString("General_CONFIG_CLASS_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(5L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT, MAX_NUMBER_OF_CLASSES_TO_REPORT);
    public static final TypedCollectionResult<ClassEntry> LOADED_CLASSES = new TypedCollectionResult("loadedClasses", Messages.getString("ClassLeakingRule_RESULT_LOADED_CLASSES_NAME"), Messages.getString("ClassLeakingRule_RESULT_LOADED_CLASSES_DESCRIPTION"), ClassEntry.CLASS_ENTRY, ClassEntry.class);
    public static final TypedResult<IMCType> MOST_LOADED_CLASS = new TypedResult("mostLoadedClass", Messages.getString("ClassLeakingRule_RESULT_MOST_LOADED_CLASS_NAME"), Messages.getString("ClassLeakingRule_RESULT_MOST_LOADED_CLASS_DESCRIPTION"), UnitLookup.CLASS, IMCType.class);
    public static final TypedResult<IQuantity> MOST_LOADED_CLASS_TIMES = new TypedResult("mostLoadedClassTimes", Messages.getString("ClassLeakingRule_RESULT_MOST_LOADED_CLASS_LOADS_NAME"), Messages.getString("ClassLeakingRule_RESULT_MOST_LOADED_CLASS_LOADS_DESCRIPTION"), (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final List<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LOADED_CLASSES, MOST_LOADED_CLASS, MOST_LOADED_CLASS_TIMES);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ClassLoad", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ClassUnload", RulesToolkit.EventAvailability.ENABLED).build();

    public String getId() {
        return RESULT_ID;
    }

    public String getTopic() {
        return "classloading";
    }

    public String getName() {
        return Messages.getString("ClassLeakingRule_NAME");
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider dependencyResults) {
        int warningLimit = (int)((IQuantity)valueProvider.getPreferenceValue(WARNING_LIMIT)).longValue();
        ItemQueryBuilder queryLoad = ItemQueryBuilder.fromWhere((IItemFilter)JdkFilters.CLASS_LOAD);
        queryLoad.groupBy(JdkAttributes.CLASS_LOADED);
        queryLoad.select(JdkAttributes.CLASS_LOADED);
        queryLoad.select(Aggregators.count((String)COUNT_AGGREGATOR_ID, (String)"classesLoaded"));
        Map<String, ClassEntry> entriesLoad = this.extractClassEntriesFromQuery(items, queryLoad.build());
        ItemQueryBuilder queryUnload = ItemQueryBuilder.fromWhere((IItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.CLASS_UNLOAD, ClassLeakingRule.createClassAttributeFilter((IAttribute<IMCType>)JdkAttributes.CLASS_UNLOADED, entriesLoad)}));
        queryUnload.groupBy(JdkAttributes.CLASS_UNLOADED);
        queryUnload.select(JdkAttributes.CLASS_UNLOADED);
        queryUnload.select(Aggregators.count((String)COUNT_AGGREGATOR_ID, (String)"classesUnloaded"));
        Map<String, ClassEntry> entriesUnload = this.extractClassEntriesFromQuery(items, queryUnload.build());
        Map<String, ClassEntry> diff = this.diff(entriesLoad, entriesUnload);
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>(diff.values());
        if (entries.size() > 0) {
            int classLimit = Math.min((int)((IQuantity)valueProvider.getPreferenceValue(MAX_NUMBER_OF_CLASSES_TO_REPORT)).longValue(), entries.size());
            long maxCount = 0L;
            Collections.sort(entries);
            ArrayList<ClassEntry> entriesOverLimit = new ArrayList<ClassEntry>();
            for (int i = 0; i < classLimit; ++i) {
                ClassEntry entry = (ClassEntry)entries.get(i);
                entriesOverLimit.add(entry);
                maxCount = Math.max(entry.getCount().longValue(), maxCount);
            }
            double maxScore = RulesToolkit.mapExp100((double)maxCount, (double)warningLimit) * 0.75;
            ClassEntry worst = (ClassEntry)entries.get(0);
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)maxScore)).setSummary(Messages.getString("ClassLeakingRule_RESULT_SUMMARY")).setExplanation(Messages.getString("ClassLeakingRule_RESULT_EXPLANATION")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(maxScore)).addResult(LOADED_CLASSES, entriesOverLimit).addResult(MOST_LOADED_CLASS, (Object)worst.getType()).addResult(MOST_LOADED_CLASS_TIMES, (Object)worst.getCount()).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("ClassLeakingRule_TEXT_OK")).build();
    }

    private static IItemFilter createClassAttributeFilter(IAttribute<IMCType> attribute, Map<String, ClassEntry> entries) {
        ArrayList<IItemFilter> allowedClasses = new ArrayList<IItemFilter>();
        for (ClassEntry entry : entries.values()) {
            allowedClasses.add(ItemFilters.equals(attribute, (Object)entry.getType()));
        }
        return ItemFilters.or((IItemFilter[])allowedClasses.toArray(new IItemFilter[0]));
    }

    private Map<String, ClassEntry> diff(Map<String, ClassEntry> entriesLoad, Map<String, ClassEntry> entriesUnload) {
        if (entriesUnload.isEmpty()) {
            return entriesLoad;
        }
        HashMap<String, ClassEntry> diffMap = new HashMap<String, ClassEntry>(entriesLoad.size());
        for (Map.Entry<String, ClassEntry> mapEntryLoad : entriesLoad.entrySet()) {
            ClassEntry classEntryUnload = entriesUnload.get(mapEntryLoad.getKey());
            if (classEntryUnload != null) {
                diffMap.put(mapEntryLoad.getKey(), new ClassEntry(mapEntryLoad.getValue().getType(), mapEntryLoad.getValue().getCount().subtract(classEntryUnload.getCount())));
                continue;
            }
            diffMap.put(mapEntryLoad.getKey(), mapEntryLoad.getValue());
        }
        return diffMap;
    }

    private Map<String, ClassEntry> extractClassEntriesFromQuery(IItemCollection items, IItemQuery query) {
        HashMap<String, ClassEntry> entries = new HashMap<String, ClassEntry>();
        IItemResultSet resultSet = new ItemResultSetFactory().createResultSet(items, query);
        ColumnInfo countColumn = resultSet.getColumnMetadata().get(COUNT_AGGREGATOR_ID);
        ColumnInfo classColumn = resultSet.getColumnMetadata().get(query.getGroupBy().getIdentifier());
        while (resultSet.next()) {
            try {
                IMCType type;
                IQuantity countObject = (IQuantity)resultSet.getValue(countColumn.getColumn());
                if (countObject == null || (type = (IMCType)resultSet.getValue(classColumn.getColumn())) == null) continue;
                ClassEntry entry = new ClassEntry(type, countObject);
                entries.put(entry.getType().getFullName(), entry);
            }
            catch (ItemResultSetException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to extract class entries from query!", e);
            }
        }
        return entries;
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider preferenceValueProvider, final IResultValueProvider dependencyResults) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return ClassLeakingRule.this.getResult(items, preferenceValueProvider, dependencyResults);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

