/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.exceptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.collection.MapToolkit;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class ErrorRule
extends AbstractRule {
    private static final String RESULT_ID = "Errors";
    public static final TypedPreference<IQuantity> ERROR_INFO_LIMIT = new TypedPreference("error.info.limit", Messages.getString("ErrorRule_CONFIG_INFO_LIMIT"), Messages.getString("ErrorRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(30L));
    public static final TypedPreference<IQuantity> ERROR_WARNING_LIMIT = new TypedPreference("error.warning.limit", Messages.getString("ErrorRule_CONFIG_WARN_LIMIT"), Messages.getString("ErrorRule_CONFIG_WARN_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(60L));
    public static final TypedPreference<String> EXCLUDED_ERRORS_REGEXP = new TypedPreference("error.exclude.regexp", Messages.getString("ErrorRule_CONFIG_EXCLUDED_ERRORS"), Messages.getString("ErrorRule_CONFIG_EXCLUDED_ERRORS_LONG"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"(com.sun.el.parser.ELParser\\$LookaheadSuccess)");
    public static final TypedPreference<IQuantity> ERROR_WINDOW_SIZE = new TypedPreference("error.window.size", Messages.getString("ErrorRule_CONFIG_WINDOW_SIZE"), Messages.getString("ErrorRule_CONFIG_WINDOW_SIZE_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(60L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(ERROR_INFO_LIMIT, ERROR_WARNING_LIMIT, EXCLUDED_ERRORS_REGEXP, ERROR_WINDOW_SIZE);
    public static final TypedResult<IRange<IQuantity>> ERROR_WINDOW = new TypedResult("errorWindow", "Error Window", "The window during which the rule detected the most errors.", UnitLookup.TIMERANGE);
    public static final TypedResult<IQuantity> ERROR_RATE = new TypedResult("errorRate", "Error Rate", "The rate of errors created.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> ERROR_COUNT = new TypedResult("errorCount", "Error Count", "The total amount of errors created.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IMCType> MOST_COMMON_ERROR = new TypedResult("mostCommonError", "Most Common Error", "The most common error thrown.", UnitLookup.CLASS, IMCType.class);
    public static final TypedResult<IQuantity> MOST_COMMON_ERROR_COUNT = new TypedResult("mostCommonErrorCount", "Most Common Error Count", "The number of times the most common error type was thrown.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> EXCLUDED_ERRORS = new TypedResult("excludedErrors", "Excluded Errors", "The number of errors excluded from the rule evaluation.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, ERROR_COUNT, EXCLUDED_ERRORS, ERROR_RATE, ERROR_WINDOW, MOST_COMMON_ERROR, MOST_COMMON_ERROR_COUNT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JavaErrorThrow", RulesToolkit.EventAvailability.AVAILABLE).build();

    protected IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IQuantity errorCount;
        long warnLimit = ((IQuantity)vp.getPreferenceValue(ERROR_WARNING_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        long infoLimit = ((IQuantity)vp.getPreferenceValue(ERROR_INFO_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        String errorExcludeRegexp = ((String)vp.getPreferenceValue(EXCLUDED_ERRORS_REGEXP)).trim();
        IItemCollection errorItems = items;
        IQuantity excludedErrors = null;
        if (!errorExcludeRegexp.isEmpty()) {
            IItemFilter matchesExclude = ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.EXCEPTION_THROWNCLASS_NAME, (String)errorExcludeRegexp);
            IItemFilter errorsExcludingExclude = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.JavaErrorThrow"), ItemFilters.not((IItemFilter)matchesExclude)});
            errorItems = errorItems.apply(errorsExcludingExclude);
            excludedErrors = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.count(), (IItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.JavaErrorThrow"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.EXCEPTION_THROWNCLASS_NAME, (String)errorExcludeRegexp)})));
        }
        if ((errorCount = (IQuantity)errorItems.getAggregate(JdkAggregators.ERROR_COUNT)) != null && errorCount.doubleValue() > 0.0) {
            final ArrayList errorsList = new ArrayList();
            IQuantity windowSize = (IQuantity)vp.getPreferenceValue(ERROR_WINDOW_SIZE);
            IQuantity slideSize = windowSize.getUnit().quantity(windowSize.ratioTo(windowSize.getUnit().quantity(2L)));
            SlidingWindowToolkit.slidingWindowUnordered((SlidingWindowToolkit.IUnorderedWindowVisitor)new SlidingWindowToolkit.IUnorderedWindowVisitor(){

                public void visitWindow(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                    IRange timeRange = QuantityRange.createWithEnd((IQuantity)startTime, (IQuantity)endTime);
                    Double errors = ((IQuantity)items.getAggregate(Aggregators.count())).doubleValue();
                    if (errors > 0.0) {
                        ITypedQuantity errorsPerMinute = UnitLookup.NUMBER_UNITY.quantity(errors / ((IQuantity)timeRange.getExtent()).doubleValueIn((IUnit)UnitLookup.MINUTE));
                        errorsList.add(new Pair((Object)errorsPerMinute, (Object)timeRange));
                    }
                }

                public boolean shouldContinue() {
                    return !ErrorRule.this.evaluationTask.isCancelled();
                }
            }, (IItemCollection)errorItems, (IQuantity)windowSize, (IQuantity)slideSize);
            Pair<IQuantity, IRange<IQuantity>> maxErrorsPerMinute = Collections.max(errorsList, new Comparator<Pair<IQuantity, IRange<IQuantity>>>(){

                @Override
                public int compare(Pair<IQuantity, IRange<IQuantity>> o1, Pair<IQuantity, IRange<IQuantity>> o2) {
                    return ((IQuantity)o1.left).compareTo(o2.left);
                }
            });
            List errorGrouping = RulesToolkit.calculateGroupingScore((IItemCollection)errorItems, (IAccessorFactory)JdkAttributes.EXCEPTION_THROWNCLASS);
            IMCType mostCommonError = (IMCType)((MapToolkit.IntEntry)errorGrouping.get(errorGrouping.size() - 1)).getKey();
            int errorsThrown = ((MapToolkit.IntEntry)errorGrouping.get(errorGrouping.size() - 1)).getValue();
            double score = RulesToolkit.mapExp100((double)((IQuantity)maxErrorsPerMinute.left).doubleValue(), (double)infoLimit, (double)warnLimit);
            String longMessage = Messages.getString("ErrorRule_TEXT_WARN_LONG");
            if (excludedErrors != null && excludedErrors.longValue() > 0L) {
                longMessage = longMessage + " " + Messages.getString("ErrorRule_TEXT_WARN_EXCLUDED_INFO");
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("ErrorRule_TEXT_WARN")).setExplanation(longMessage).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(ERROR_COUNT, (Object)errorCount).addResult(ERROR_WINDOW, maxErrorsPerMinute.right).addResult(ERROR_RATE, maxErrorsPerMinute.left).addResult(MOST_COMMON_ERROR, (Object)mostCommonError).addResult(EXCLUDED_ERRORS, (Object)excludedErrors).addResult(TypedResult.ITEM_QUERY, (Object)JdkQueries.ERRORS).addResult(MOST_COMMON_ERROR_COUNT, (Object)UnitLookup.NUMBER_UNITY.quantity((long)errorsThrown)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("ErrorRule_TEXT_OK")).build();
    }

    public ErrorRule() {
        super(RESULT_ID, Messages.getString("ErrorRule_RULE_NAME"), "exceptions", CONFIG_ATTRIBUTES, RESULT_ATTRIBUTES, REQUIRED_EVENTS);
    }
}

