/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.maven.mojo;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.libj.util.CollectionUtil;
import org.openjax.maven.mojo.FilterMojo;

@Mojo(name="resources")
public abstract class ResourcesMojo
extends FilterMojo {
    @Parameter(defaultValue="${project.resources}", required=true, readonly=true)
    private List<Resource> mainResources;
    @Parameter(defaultValue="${project.testResources}", required=true, readonly=true)
    private List<Resource> testResources;

    @Override
    public final void execute(FilterMojo.Configuration configuration) throws MojoExecutionException, MojoFailureException {
        if (this.mainResources.size() == 0 && this.testResources.size() == 0) {
            if (configuration.getFailOnNoOp()) {
                throw new MojoExecutionException("Failing due to empty resources (failOnNoOp=true)");
            }
            this.getLog().info((CharSequence)"Skipping due to empty resources.");
            return;
        }
        this.execute(new Configuration(configuration, new LinkedHashSet<Resource>(this.mainResources), new LinkedHashSet<Resource>(this.testResources)));
    }

    public abstract void execute(Configuration var1) throws MojoExecutionException, MojoFailureException;

    public class Configuration
    extends FilterMojo.Configuration {
        private final LinkedHashSet<Resource> mainResources;
        private final LinkedHashSet<Resource> testResources;
        private LinkedHashSet<Resource> resources;

        public Configuration(Configuration configuration) {
            this(configuration, configuration.mainResources, configuration.testResources);
        }

        private Configuration(FilterMojo.Configuration configuration, LinkedHashSet<Resource> mainResources, LinkedHashSet<Resource> testResources) {
            super(configuration);
            this.mainResources = mainResources;
            this.testResources = testResources;
        }

        public LinkedHashSet<Resource> getMainResources() {
            return this.mainResources;
        }

        public LinkedHashSet<Resource> getTestResources() {
            return this.testResources;
        }

        public LinkedHashSet<Resource> getResources() {
            return this.resources == null ? (LinkedHashSet)CollectionUtil.concat(new LinkedHashSet(), (Collection[])new Collection[]{this.mainResources, this.testResources}) : this.resources;
        }
    }
}

