/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Predicate;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openjax.maven.mojo.ResourcesMojo;

@Mojo(name="patternset")
public abstract class PatternSetMojo
extends ResourcesMojo {
    private boolean converted;
    @Parameter(property="includes")
    private List<String> includes;
    @Parameter(property="excludes")
    private List<String> excludes;

    private static LinkedHashSet<URI> getFiles(MavenProject project, LinkedHashSet<? extends Resource> projectResources, PatternSetMojo fileSet) throws IOException {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        if (projectResources.size() > 0) {
            for (Resource resource : projectResources) {
                File dir = new File(resource.getDirectory());
                if (!dir.exists()) continue;
                Files.walk(dir.toPath(), new FileVisitOption[0]).filter(PatternSetMojo.filter(project.getBasedir(), fileSet)).forEach(p -> uris.add(p.toUri()));
            }
        }
        return uris;
    }

    private static Predicate<Path> filter(File dir, PatternSetMojo fileSet) {
        return path -> {
            File file = path.toFile();
            if (!file.isFile()) {
                return false;
            }
            return PatternSetMojo.filter(dir, file, fileSet.getIncludes()) && !PatternSetMojo.filter(dir, file, fileSet.getExcludes());
        };
    }

    private static boolean filter(File dir, File pathname, List<String> filters) {
        int i$;
        if (filters != null && (i$ = filters.size()) > 0) {
            if (filters instanceof RandomAccess) {
                int i = 0;
                do {
                    if (!PatternSetMojo.isMatch(dir, pathname, filters.get(i))) continue;
                    return true;
                } while (++i < i$);
            } else {
                Iterator<String> i = filters.iterator();
                do {
                    if (!PatternSetMojo.isMatch(dir, pathname, i.next())) continue;
                    return true;
                } while (i.hasNext());
            }
        }
        return false;
    }

    private static boolean isMatch(File dir, File pathname, String filter) {
        return pathname.getAbsolutePath().substring(dir.getAbsolutePath().length() + 1).matches(filter);
    }

    static String convertToRegex(String pattern) {
        String regex = pattern.replace("\\", "\\\\").replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("$", "\\$").replace("^", "\\^").replace("**\\", "\u0007\u0007\u0007").replace("**/", "\u0007\u0007\u0007").replace("\\**", "\u0007\u0007\u0007").replace("/**", "\u0007\u0007\u0007").replace("*", "[^\u0007\\\\]*").replace("\u0007\u0007\u0007", ".*").replace("/", "\\/").replace('\u0007', '/').replace('?', '.');
        char ch = regex.charAt(regex.length() - 1);
        return ch == '/' || ch == '\\' ? regex + ".*" : regex;
    }

    private static void convertToRegex(List<String> list) {
        int i$;
        if (list != null && (i$ = list.size()) > 0) {
            Iterator<String> iterator = list.iterator();
            for (int i = 0; i < i$; ++i) {
                list.set(i, PatternSetMojo.convertToRegex(iterator.next()));
            }
        }
    }

    private void convert() {
        if (!this.converted) {
            PatternSetMojo.convertToRegex(this.includes);
            PatternSetMojo.convertToRegex(this.excludes);
            this.converted = true;
        }
    }

    private List<String> getIncludes() {
        this.convert();
        return this.includes;
    }

    private List<String> getExcludes() {
        this.convert();
        return this.excludes;
    }

    @Override
    public final void execute(ResourcesMojo.Configuration configuration) throws MojoExecutionException, MojoFailureException {
        try {
            Map<String, Object> filterParameters = this.getFilterParameters();
            LinkedHashSet<URI> fileSets = PatternSetMojo.getFiles(this.project, configuration.getResources(), this);
            if (fileSets.size() == 0 && (filterParameters == null || filterParameters.isEmpty())) {
                if (configuration.getFailOnNoOp()) {
                    throw new MojoExecutionException("Empty input parameters (failOnNoOp=true)");
                }
                this.getLog().info((CharSequence)"Skipping for empty input parameters.");
                return;
            }
            this.execute(new Configuration(configuration, fileSets, this.getIncludes() == null ? null : new LinkedHashSet<String>(this.getIncludes()), this.getExcludes() == null ? null : new LinkedHashSet<String>(this.getExcludes())));
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), e);
        }
    }

    public abstract void execute(Configuration var1) throws MojoExecutionException, MojoFailureException;

    public class Configuration
    extends ResourcesMojo.Configuration {
        private final LinkedHashSet<URI> fileSets;
        private final LinkedHashSet<String> includes;
        private final LinkedHashSet<String> excludes;

        public Configuration(Configuration configuration) {
            this(configuration, configuration.fileSets, configuration.includes, configuration.excludes);
        }

        private Configuration(ResourcesMojo.Configuration configuration, LinkedHashSet<URI> fileSets, LinkedHashSet<String> includes, LinkedHashSet<String> excludes) {
            super(PatternSetMojo.this, configuration);
            this.fileSets = Objects.requireNonNull(fileSets);
            this.includes = includes;
            this.excludes = excludes;
        }

        public LinkedHashSet<URI> getFileSets() {
            return this.fileSets;
        }

        public LinkedHashSet<String> getIncludes() {
            return this.includes;
        }

        public LinkedHashSet<String> getExcludes() {
            return this.excludes;
        }
    }
}

