/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.maven.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.libj.lang.Strings;

public final class MojoUtil {
    public static PluginExecution getPluginExecution(MojoExecution execution) {
        Plugin plugin = execution.getPlugin();
        plugin.flushExecutionMap();
        List executions = plugin.getExecutions();
        int i$ = executions.size();
        if (i$ > 0) {
            if (executions instanceof RandomAccess) {
                int i = 0;
                do {
                    PluginExecution pluginExecution;
                    if (!(pluginExecution = (PluginExecution)executions.get(i)).getId().equals(execution.getExecutionId())) continue;
                    return pluginExecution;
                } while (++i < i$);
            } else {
                Iterator i = executions.iterator();
                do {
                    PluginExecution pluginExecution;
                    if (!(pluginExecution = (PluginExecution)i.next()).getId().equals(execution.getExecutionId())) continue;
                    return pluginExecution;
                } while (i.hasNext());
            }
        }
        return null;
    }

    public static boolean isInTestPhase(MojoExecution execution) {
        return execution.getLifecyclePhase() != null && execution.getLifecyclePhase().contains("test");
    }

    public static boolean shouldSkip(MojoExecution execution, boolean mavenTestSkip) {
        if (!mavenTestSkip) {
            return false;
        }
        if (execution != null && MojoUtil.isInTestPhase(execution)) {
            return true;
        }
        PluginExecution pluginExecution = MojoUtil.getPluginExecution(execution);
        return pluginExecution != null && pluginExecution.getPhase() != null && pluginExecution.getPhase().contains("test");
    }

    public static Artifact toArtifact(ComponentDependency dependency, ArtifactHandler handler) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), null, dependency.getType(), null, handler);
    }

    public static Artifact toArtifact(Dependency dependency, ArtifactHandler handler) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), handler);
    }

    public static List<String> getPluginDependencyClassPath(PluginDescriptor descriptor, ArtifactRepository localRepository, ArtifactHandler handler) {
        List dependencies = descriptor.getDependencies();
        int len = dependencies.size();
        ArrayList<String> classpath = new ArrayList<String>(len);
        for (ComponentDependency dependency : dependencies) {
            classpath.add(localRepository.getBasedir() + File.separator + localRepository.pathOf(MojoUtil.toArtifact(dependency, handler)));
        }
        return classpath;
    }

    public static String getPathOf(ArtifactRepository localRepository, Dependency dependency) {
        StringBuilder builder = new StringBuilder();
        builder.append(localRepository.getBasedir());
        builder.append(File.separatorChar);
        builder.append(dependency.getGroupId().replace('.', File.separatorChar));
        builder.append(File.separatorChar);
        builder.append(dependency.getArtifactId());
        builder.append(File.separatorChar);
        builder.append(dependency.getVersion());
        builder.append(File.separatorChar);
        builder.append(dependency.getArtifactId());
        builder.append('-');
        builder.append(dependency.getVersion());
        if ("test-jar".equals(dependency.getType())) {
            builder.append("-tests");
        }
        return builder.append(".jar").toString();
    }

    public static String[] getProjectDependencyPaths(MavenProject project, ArtifactRepository localRepository) {
        List dependencies = project.getExecutionProject().getDependencies();
        int i$ = dependencies.size();
        if (i$ == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] classpath = new String[i$];
        Iterator iterator = dependencies.iterator();
        for (int i = 0; i < i$; ++i) {
            classpath[i] = MojoUtil.getPathOf(localRepository, (Dependency)iterator.next());
        }
        return classpath;
    }

    public static void assertCreateDir(String name, File dir) throws MojoFailureException {
        if (dir.exists()) {
            if (dir.isFile()) {
                throw new MojoFailureException("Path at " + name + " directory is a file: " + dir.getAbsolutePath());
            }
        } else if (!dir.mkdirs()) {
            throw new MojoFailureException("Unable to create " + name + " directory: " + dir.getAbsolutePath());
        }
    }

    public static File[] getExecutionClasspath(MavenProject project, MojoExecution execution, PluginDescriptor descriptor, ArtifactRepository localRepository, ArtifactHandler handler) throws DependencyResolutionRequiredException {
        List<String> classpath = MojoUtil.getPluginDependencyClassPath(descriptor, localRepository, handler);
        classpath.addAll(project.getCompileClasspathElements());
        classpath.addAll(project.getRuntimeClasspathElements());
        if (MojoUtil.isInTestPhase(execution)) {
            classpath.addAll(project.getTestClasspathElements());
            Collections.addAll(classpath, MojoUtil.getProjectDependencyPaths(project, localRepository));
        }
        File[] classpathFiles = new File[classpath.size()];
        int i$ = classpathFiles.length;
        for (int i = 0; i < i$; ++i) {
            classpathFiles[i] = new File(classpath.get(i));
        }
        return classpathFiles;
    }

    private MojoUtil() {
    }
}

