/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.maven.mojo;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openjax.maven.mojo.FilterMojo;
import org.openjax.maven.mojo.MojoUtil;

@Mojo(name="generator")
public abstract class GeneratorMojo
extends FilterMojo {
    @Parameter(property="destDir", required=true)
    private File destDir;
    @Parameter(property="overwrite")
    private boolean overwrite = true;

    @Override
    public final void execute(FilterMojo.Configuration configuration) throws MojoExecutionException, MojoFailureException {
        MojoUtil.assertCreateDir("destination", this.destDir);
        this.getLog().info((CharSequence)("Writing files to: " + new File("").getAbsoluteFile().toPath().relativize(this.destDir.getAbsoluteFile().toPath()).toString()));
        this.execute(new Configuration(configuration, this.destDir, this.overwrite));
        if (this.isInTestPhase()) {
            this.project.addTestCompileSourceRoot(this.destDir.getAbsolutePath());
        } else {
            this.project.addCompileSourceRoot(this.destDir.getAbsolutePath());
        }
    }

    public abstract void execute(Configuration var1) throws MojoExecutionException, MojoFailureException;

    public class Configuration
    extends FilterMojo.Configuration {
        private final File destDir;
        private final boolean overwrite;

        public Configuration(Configuration configuration) {
            this(configuration, configuration.destDir, configuration.overwrite);
        }

        private Configuration(FilterMojo.Configuration configuration, File destDir, boolean overwrite) {
            super(configuration);
            this.destDir = destDir;
            this.overwrite = overwrite;
        }

        public File getDestDir() {
            return this.destDir;
        }

        public boolean getOverwrite() {
            return this.overwrite;
        }
    }
}

