/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.maven.mojo;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.libj.util.ArrayUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public final class AnnotationUtil {
    private static final Type[] PRIMITIVE_TYPES = new Type[]{Type.BOOLEAN_TYPE, Type.BYTE_TYPE, Type.SHORT_TYPE, Type.CHAR_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE};

    private static boolean isPrimitive(Type type) {
        return ArrayUtil.contains((Object[])PRIMITIVE_TYPES, (Object)type);
    }

    private static Object getInstance(Type type, Object value) {
        if (AnnotationUtil.isPrimitive(type) || String.class.getName().equals(type.getClassName())) {
            return value;
        }
        if (Enumeration.class.getName().equals(type.getClassName())) {
            throw new UnsupportedOperationException();
        }
        try {
            if (Class.class.getName().equals(type.getClassName())) {
                return Class.forName((String)value);
            }
            Class<?> cls = Class.forName(type.getClassName());
            if (cls.isEnum()) {
                return Enum.valueOf(cls, (String)value);
            }
            throw new UnsupportedOperationException();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, Object> getAnnotationParameters(List<?> annotations, String desc) {
        int i$;
        if (annotations == null || (i$ = annotations.size()) == 0) {
            return null;
        }
        for (int i = 0; i < i$; ++i) {
            AnnotationNode annotationNode = (AnnotationNode)annotations.get(i);
            if (!desc.equals(annotationNode.desc)) continue;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            List values = annotationNode.values;
            if (values != null) {
                int j = 0;
                int j$ = values.size();
                while (j < j$) {
                    String[] data;
                    Type type;
                    Object rawValue;
                    String name = (String)values.get(j++);
                    Object value = (rawValue = values.get(j++)) instanceof String[] ? AnnotationUtil.getInstance((type = Type.getType((String)(data = (String[])rawValue)[0])).getSort() == 9 ? type.getElementType() : type, data[1]) : rawValue;
                    parameters.put(name, value);
                }
            }
            return parameters;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotationParameters(Class<?> cls, Class<T> annotationType) throws IOException {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(cls.getName().replace('.', '/') + ".class");){
            if (in == null) {
                throw new IllegalStateException("Unable to locate bytecode for class " + cls.getName() + " in context class loader " + Thread.currentThread().getContextClassLoader());
            }
            ClassReader classReader = new ClassReader(in);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            String desc = "L" + annotationType.getName().replace('.', '/') + ";";
            Map<String, Object> invisible = AnnotationUtil.getAnnotationParameters(classNode.invisibleAnnotations, desc);
            if (invisible != null) {
                T t = AnnotationUtil.annotationForMap(annotationType, invisible);
                return t;
            }
            Map<String, Object> visible = AnnotationUtil.getAnnotationParameters(classNode.visibleAnnotations, desc);
            T t = visible == null ? null : (T)AnnotationUtil.annotationForMap(annotationType, visible);
            return t;
        }
    }

    public static <T extends Annotation> T getAnnotationParameters(Field field, Class<T> annotationType) throws IOException {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(field.getDeclaringClass().getName().replace('.', '/') + ".class");){
            if (in == null) {
                throw new IllegalStateException("Unable to locate bytecode for class " + field.getDeclaringClass().getName() + " in context class loader " + Thread.currentThread().getContextClassLoader());
            }
            ClassReader classReader = new ClassReader(in);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            List fields = classNode.fields;
            int i$ = fields.size();
            for (int i = 0; i < i$; ++i) {
                FieldNode fieldNode = (FieldNode)fields.get(i);
                if (!field.getName().equals(fieldNode.name)) continue;
                String desc = "L" + annotationType.getName().replace('.', '/') + ";";
                Map<String, Object> invisible = AnnotationUtil.getAnnotationParameters(fieldNode.invisibleAnnotations, desc);
                if (invisible != null) {
                    T t = AnnotationUtil.annotationForMap(annotationType, invisible);
                    return t;
                }
                Map<String, Object> visible = AnnotationUtil.getAnnotationParameters(fieldNode.visibleAnnotations, desc);
                T t = visible == null ? null : (T)AnnotationUtil.annotationForMap(annotationType, visible);
                return t;
            }
            T t = null;
            return t;
        }
    }

    static <T extends Annotation> T annotationForMap(Class<T> annotationType, final Map<String, Object> memberValues) {
        Objects.requireNonNull(memberValues);
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                return memberValues.get(method.getName());
            }
        }));
    }

    private AnnotationUtil() {
    }
}

