/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.expect;

import java.io.IOException;
import java.io.InputStream;

public class NonBlockingInputStream
extends InputStream {
    private final InputStream in;
    private final byte[] buffer;
    private final int tempBufferSize;
    private volatile int writeAhead;
    private volatile int writeIndex = 0;
    private volatile int readIndex = 0;
    private volatile IOException ioException;
    private boolean eof = false;
    private int lost = 0;

    public NonBlockingInputStream(InputStream in, int bufferSize) {
        if (bufferSize == 0) {
            throw new IllegalArgumentException("bufferSize cannot be 0");
        }
        this.in = in;
        this.buffer = new byte[bufferSize];
        this.tempBufferSize = (int)Math.round(Math.log(bufferSize) / Math.log(2.0));
        this.writeAhead = bufferSize;
        new ReaderThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (this.eof) {
            return -1;
        }
        if (this.writeAhead == this.buffer.length) {
            return 0;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            byte value = this.buffer[this.readIndex];
            if (++this.readIndex == this.buffer.length) {
                this.readIndex = 0;
            }
            if (++this.writeAhead == this.buffer.length) {
                this.writeAhead = this.buffer.length;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return value;
        }
    }

    public int getLostBytesCount() {
        return this.lost;
    }

    private final class ReaderThread
    extends Thread {
        public ReaderThread() {
            this.setName(NonBlockingInputStream.this.getClass().getSimpleName() + "$" + this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()));
            this.setPriority(10);
        }

        @Override
        public void run() {
            int length = 0;
            byte[] bytes = new byte[NonBlockingInputStream.this.tempBufferSize];
            try {
                while ((length = NonBlockingInputStream.this.in.read(bytes)) != -1) {
                    NonBlockingInputStream.this.writeAhead = NonBlockingInputStream.this.writeAhead - length;
                    if (NonBlockingInputStream.this.buffer.length <= NonBlockingInputStream.this.writeIndex + length) {
                        System.arraycopy(bytes, 0, NonBlockingInputStream.this.buffer, NonBlockingInputStream.this.writeIndex, NonBlockingInputStream.this.buffer.length - NonBlockingInputStream.this.writeIndex);
                        System.arraycopy(bytes, NonBlockingInputStream.this.buffer.length - NonBlockingInputStream.this.writeIndex, NonBlockingInputStream.this.buffer, 0, NonBlockingInputStream.this.writeIndex = bytes.length - NonBlockingInputStream.this.buffer.length + NonBlockingInputStream.this.writeIndex);
                    } else {
                        System.arraycopy(bytes, 0, NonBlockingInputStream.this.buffer, NonBlockingInputStream.this.writeIndex, length);
                        NonBlockingInputStream.this.writeIndex = NonBlockingInputStream.this.writeIndex + length;
                    }
                    if (NonBlockingInputStream.this.writeAhead > 0) continue;
                    NonBlockingInputStream.this.lost = NonBlockingInputStream.this.lost + -1 * NonBlockingInputStream.this.writeAhead;
                    NonBlockingInputStream.this.writeAhead = 0;
                    NonBlockingInputStream.this.readIndex = NonBlockingInputStream.this.writeIndex;
                }
                NonBlockingInputStream.this.eof = true;
            }
            catch (IOException e) {
                NonBlockingInputStream.this.ioException = e;
            }
        }
    }
}

