/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.expect;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openjax.expect.ListTree;
import org.openjax.expect.ScannerHandler;

public class InputStreamScanner
extends Thread {
    private final InputStream in;
    private List<ListTree.Node<ScannerHandler>> currentNodes;

    public InputStreamScanner(InputStream in, ListTree<ScannerHandler> handlers) {
        super(InputStreamScanner.class.getSimpleName());
        this.in = in;
        this.currentNodes = handlers == null ? null : handlers.getChildren();
    }

    private boolean onMatch(String line, List<ListTree.Node<ScannerHandler>> nodes) throws IOException {
        boolean match = false;
        for (ListTree.Node<ScannerHandler> node : nodes) {
            if (node.getValue() == null) {
                for (ListTree.Node<ScannerHandler> child : node.getChildren()) {
                    this.onMatch(line, child.getChildren());
                }
                continue;
            }
            if (!line.matches(node.getValue().getPattern())) continue;
            match = true;
            node.getValue().match(line);
            this.currentNodes = node.getChildren();
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder builder = new StringBuilder();
        try {
            char ch;
            while ((ch = (char)this.in.read()) != '\uffffffff') {
                if (ch == '\n') {
                    builder.setLength(0);
                } else if (ch != ' ' || builder.length() != 0) {
                    builder.append(ch);
                }
                if (this.currentNodes == null || !this.onMatch(builder.toString(), this.currentNodes)) continue;
                if (this.currentNodes == null) {
                    return;
                }
                builder.setLength(0);
            }
        }
        catch (Exception e) {
            if ("Pipe broken".equals(e.getMessage())) {
                return;
            }
            throw new IllegalStateException(e);
        }
        finally {
            InputStreamScanner inputStreamScanner = this;
            synchronized (inputStreamScanner) {
                try {
                    this.notifyAll();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }
    }
}

