/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.expect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.libj.exec.Processes;
import org.libj.util.ClassLoaders;
import org.libj.util.Strings;
import org.openjax.expect.ExpectCallback;
import org.openjax.expect.InputStreamScanner;
import org.openjax.expect.ListTree;
import org.openjax.expect.NonBlockingInputStream;
import org.openjax.expect.ScannerHandler;
import org.openjax.expect_0_2.ProcessType;
import org.openjax.expect_0_2.RuleType;
import org.openjax.expect_0_2.Script;
import org.openjax.jaxb.xjc.JaxbUtil;

public class Expect {
    public static void start(InputStream in, OutputStream out, OutputStream err, final ExpectCallback callback, URL scriptUrl) throws Exception {
        Process process;
        boolean sync;
        Script script = (Script)JaxbUtil.parse(Script.class, (URL)scriptUrl);
        ProcessType processType = script.getProcess();
        String exec = processType.getExec().trim();
        Map<String, String> variables = callback.process(exec);
        ArrayList<String> args = new ArrayList<String>();
        String command = Expect.dereference(exec, variables);
        int end = -1;
        while (end < command.length()) {
            int i;
            int start = command.indexOf(32, end + 1);
            if (start == -1) {
                start = command.length();
            }
            if (end + 1 == start) {
                end = start;
                continue;
            }
            String arg = command.substring(end + 1, start);
            for (i = 0; i < arg.length() && Character.isWhitespace(arg.charAt(i)); ++i) {
            }
            char ch0 = arg.charAt(0);
            if (ch0 == '\"') {
                start = Strings.indexOfUnQuoted((CharSequence)command, (char)'\"', (int)(start + 2 + i));
                arg = command.substring(end + 2, start);
            } else if (ch0 == '\'') {
                start = Strings.indexOfUnQuoted((CharSequence)command, (char)'\'', (int)(start + 2 + i));
                arg = command.substring(end + 2, start);
            }
            args.add(arg.trim());
            end = start;
        }
        boolean bl = sync = processType.getFork() != null && "sync".equals(processType.getFork());
        if (exec.startsWith("java")) {
            String className = null;
            HashMap<String, String> props = new HashMap<String, String>();
            ArrayList<String> javaArgs = new ArrayList<String>();
            for (String arg : args) {
                if (arg.startsWith("-D")) {
                    String[] parts = arg.substring(2).split("=", 2);
                    props.put(parts[0], parts[1]);
                    continue;
                }
                if (arg.matches("([_a-zA-Z0-9]+\\.)+[_a-zA-Z0-9]+")) {
                    if (className != null) {
                        throw new IllegalArgumentException("There is a problem with the regex used to determine the final class name. We have matched it twice!!");
                    }
                    className = arg;
                    continue;
                }
                if ("java".equals(arg)) continue;
                javaArgs.add(arg);
            }
            process = Processes.forkAsync((InputStream)in, (OutputStream)out, (OutputStream)err, (boolean)false, null, null, (File[])ClassLoaders.getClassPath(), null, props, Class.forName(className), (String[])javaArgs.toArray(new String[javaArgs.size()]));
        } else {
            process = Processes.forkAsync((InputStream)in, (OutputStream)out, (OutputStream)err, (boolean)false, null, null, (String[])args.toArray(new String[args.size()]));
        }
        try (NonBlockingInputStream stream = new NonBlockingInputStream(process.getErrorStream(), 1024);){
            ListTree.Node<1> treeNode;
            Object scanner;
            InputStream stdout = process.getInputStream();
            ListTree.Node<1> firstTreeNode = null;
            List<RuleType> rules = processType.getRule();
            HashMap<String, 1> scannerMap = new HashMap<String, 1>();
            HashMap<String, ListTree.Node<1>> treeNodeMap = new HashMap<String, ListTree.Node<1>>();
            for (final RuleType ruleType : rules) {
                scanner = new ScannerHandler(ruleType.getExpect()){

                    @Override
                    public void match(String line) throws IOException {
                        try {
                            String response = ruleType.getRespond();
                            Map<String, String> variables = callback.rule(ruleType.getId(), ruleType.getExpect(), response, line);
                            response = Expect.dereference(response, variables);
                            process.getOutputStream().write(response.getBytes());
                            process.getOutputStream().flush();
                        }
                        catch (InterruptedException e) {
                            process.destroy();
                        }
                    }
                };
                scannerMap.put(ruleType.getId(), scanner);
                treeNode = new ListTree.Node<1>(scanner);
                treeNodeMap.put(ruleType.getId(), treeNode);
                if (firstTreeNode != null) continue;
                firstTreeNode = treeNode;
            }
            List<ProcessType.Tree.Node> nodes = processType.getTree().getNode();
            for (ProcessType.Tree.Node node : nodes) {
                treeNode = (ListTree.Node<1>)treeNodeMap.get(((RuleType)node.getRule()).getId());
                List<Object> children = node.getChildren();
                if (children == null) continue;
                for (Object childId : children) {
                    treeNode.addChild((ListTree.Node)treeNodeMap.get(((RuleType)childId).getId()));
                }
            }
            ListTree<ScannerHandler> listTree = new ListTree<ScannerHandler>();
            listTree.addChild(firstTreeNode);
            scanner = new InputStreamScanner(stdout, listTree);
            ((Thread)scanner).start();
        }
        if (sync) {
            process.waitFor();
        }
    }

    private static String dereference(String string, Map<String, String> variables) {
        return Strings.derefEL((String)string, variables);
    }

    private Expect() {
    }
}

