/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.expect;

import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.openjax.expect.NonBlockingInputStream;

public class NonBlockingInputStreamTest {
    @Test
    public void testInputStream() throws Exception {
        PipedOutputStream out = new PipedOutputStream();
        NonBlockingInputStream in = new NonBlockingInputStream((InputStream)new PipedInputStream(out), 7);
        int sleepTime = 100;
        out.write(33);
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)33L);
        out.write("\"#$%&".getBytes());
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)34L);
        Assert.assertEquals((long)in.read(), (long)35L);
        Assert.assertEquals((long)in.read(), (long)36L);
        Assert.assertEquals((long)in.read(), (long)37L);
        Assert.assertEquals((long)in.read(), (long)38L);
        out.write("'()*+,-./".getBytes());
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)41L);
        Assert.assertEquals((long)in.getLostBytesCount(), (long)2L);
        out.write("01".getBytes());
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)43L);
        Assert.assertEquals((long)in.getLostBytesCount(), (long)3L);
        out.write("23".getBytes());
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)45L);
        Assert.assertEquals((long)in.getLostBytesCount(), (long)4L);
        out.write("456".getBytes());
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)48L);
        Assert.assertEquals((long)in.getLostBytesCount(), (long)6L);
        out.write("789".getBytes());
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)51L);
        Assert.assertEquals((long)in.read(), (long)52L);
        Assert.assertEquals((long)in.read(), (long)53L);
        Assert.assertEquals((long)in.read(), (long)54L);
        Assert.assertEquals((long)in.read(), (long)55L);
        Assert.assertEquals((long)in.read(), (long)56L);
        Assert.assertEquals((long)in.read(), (long)57L);
        Assert.assertEquals((long)in.read(), (long)0L);
        Assert.assertEquals((long)in.read(), (long)0L);
        Assert.assertEquals((long)in.read(), (long)0L);
        Assert.assertEquals((long)in.read(), (long)0L);
        Assert.assertEquals((long)in.read(), (long)0L);
        Assert.assertEquals((long)in.getLostBytesCount(), (long)8L);
        out.write(":".getBytes());
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)58L);
        Assert.assertEquals((long)in.read(), (long)0L);
        out.write(";<=>?@ABCDEFG".getBytes());
        out.flush();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)65L);
        Assert.assertEquals((long)in.read(), (long)66L);
        Assert.assertEquals((long)in.read(), (long)67L);
        Assert.assertEquals((long)in.read(), (long)68L);
        Assert.assertEquals((long)in.read(), (long)69L);
        Assert.assertEquals((long)in.read(), (long)70L);
        Assert.assertEquals((long)in.read(), (long)71L);
        Assert.assertEquals((long)in.read(), (long)0L);
        Assert.assertEquals((long)in.getLostBytesCount(), (long)14L);
        out.close();
        Thread.sleep(100L);
        Assert.assertEquals((long)in.read(), (long)-1L);
        in.close();
    }
}

