/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.lang;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openingo.jdkits.collection.ArrayKit;
import org.openingo.jdkits.hash.HashKit;
import org.openingo.jdkits.lang.StringPoolKit;
import org.openingo.jdkits.validate.ValidateKit;

public final class StrKit
implements StringPoolKit {
    private static final String ILLEGAL_CHARS = "`~!#%^&*=+\\|{};:'\",<>/?\u25cb\u25cf\u2605\u2606\u2609\u2640\u2642\u203b\u00a4\u256c\u306e\u3006";

    private StrKit() {
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(CharSequence str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean notBlank(CharSequence str) {
        return !StrKit.isBlank(str);
    }

    public static boolean notBlank(CharSequence ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (CharSequence str : strings) {
            if (!StrKit.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return null == str || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StrKit.isEmpty(str);
    }

    public static String defaultIfBlank(String str, String defaultValue) {
        return StrKit.isBlank(str) ? defaultValue : str;
    }

    public static String toCamelCase(String stringWithUnderline) {
        if (stringWithUnderline.indexOf(95) == -1) {
            return stringWithUnderline;
        }
        stringWithUnderline = stringWithUnderline.toLowerCase();
        char[] fromArray = stringWithUnderline.toCharArray();
        char[] toArray = new char[fromArray.length];
        int j = 0;
        for (int i = 0; i < fromArray.length; ++i) {
            if (fromArray[i] == '_') {
                if (++i >= fromArray.length) continue;
                toArray[j++] = Character.toUpperCase(fromArray[i]);
                continue;
            }
            toArray[j++] = fromArray[i];
        }
        return new String(toArray, 0, j);
    }

    public static String join(CharSequence[] stringArray) {
        return StrKit.join(Arrays.asList(stringArray), (CharSequence)"");
    }

    public static String join(CharSequence[] stringArray, CharSequence separator) {
        return StrKit.join(Arrays.asList(stringArray), separator);
    }

    public static String join(Collection<CharSequence> collection, CharSequence separator) {
        if (ValidateKit.isEmpty(collection)) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(separator);
        collection.forEach(joiner::add);
        return joiner.toString();
    }

    public static boolean slowEquals(String a, String b) {
        byte[] aBytes = a != null ? a.getBytes() : null;
        byte[] bBytes = b != null ? b.getBytes() : null;
        return HashKit.slowEquals(aBytes, bBytes);
    }

    public static boolean equals(String a, String b) {
        return Objects.equals(a, b);
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static Integer toInteger(String obj) {
        return Integer.valueOf(obj);
    }

    public static Long toLong(String obj) {
        return Long.valueOf(obj);
    }

    public static Double toDouble(String obj) {
        return Double.valueOf(obj);
    }

    public static Float toFloat(String obj) {
        return Float.valueOf(obj);
    }

    public static boolean equalsAny(CharSequence string, CharSequence ... searchStrings) {
        if (ValidateKit.isNotEmpty(searchStrings)) {
            for (CharSequence next : searchStrings) {
                if (!StrKit.equals(string, next)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int[] convertCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }

    public static boolean isContainChinese(String str) {
        String regEx = "[\u4e00-\u9fa5]";
        return Pattern.compile(regEx).matcher(str).find();
    }

    public static String filterChinese(String string) {
        String ret = string;
        if (StrKit.isContainChinese(string)) {
            char[] chars;
            StringBuilder retBuilder = new StringBuilder();
            for (char c : chars = string.toCharArray()) {
                if (StrKit.isChinese(c)) continue;
                retBuilder.append(c);
            }
            ret = retBuilder.toString();
        }
        return ret;
    }

    public static boolean isChineseChar(char c) {
        try {
            return String.valueOf(c).getBytes(StandardCharsets.UTF_8).length > 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasIllegalChar(String string) {
        char[] chars;
        for (char aChar : chars = string.toCharArray()) {
            if (!StrKit.isIllegalChar(aChar)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIllegalChar(char c) {
        return ILLEGAL_CHARS.contains(String.valueOf(c));
    }

    public static boolean isWord(char c) {
        String regEx = "[\\w]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher("" + c);
        return m.matches();
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isChinese(String string) {
        char[] chars;
        for (char c : chars = string.toCharArray()) {
            if (StrKit.isChinese(c)) continue;
            return false;
        }
        return true;
    }

    public static List<String> filterBlank(Collection<String> strings) {
        if (Objects.isNull(strings)) {
            return Collections.emptyList();
        }
        return strings.stream().filter(StrKit::notBlank).map(String::trim).collect(Collectors.toList());
    }

    public static Set<String> filterBlank(Set<String> strings) {
        if (Objects.isNull(strings)) {
            return Collections.emptySet();
        }
        return strings.stream().filter(StrKit::notBlank).map(String::trim).collect(Collectors.toSet());
    }

    public static String utf8Str(Object obj) {
        return StrKit.str(obj, StandardCharsets.UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StrKit.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrKit.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrKit.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrKit.str((ByteBuffer)obj, charset);
        }
        if (obj.getClass().isArray()) {
            return ArrayKit.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StrKit.str(bytes, StrKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StrKit.str(bytes, StrKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StrKit.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StrKit.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }
}

