/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.lang;

import java.util.Collections;
import java.util.Map;
import net.sf.cglib.beans.BeanCopier;
import org.openingo.jdkits.lang.DiffPropertiesHelper;
import org.openingo.jdkits.reflect.ClassKit;

public interface DiffPropertiesFinder<T> {
    default public void findObjDiffProperties(Class<?> objClass, String objPropertyName, Object newValue, Object oldValue) {
        if (null == objClass || null == newValue) {
            return;
        }
        if (null == oldValue) {
            oldValue = ClassKit.newInstance(objClass);
        }
        DiffPropertiesHelper.addObjProperty(objPropertyName);
        BeanCopier.create(objClass, objClass, (boolean)false).copy(newValue, oldValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Map<String, Object> findDiffProperties(Class<T> clazz, T newOne) {
        if (null == clazz || null == newOne) {
            return Collections.emptyMap();
        }
        try {
            DiffPropertiesHelper.prepare();
            BeanCopier.create(clazz, clazz, (boolean)false).copy(newOne, (Object)this, null);
            Map<String, Object> ret = DiffPropertiesHelper.get();
            if (null == ret) {
                ret = Collections.emptyMap();
            }
            Map<String, Object> map = ret;
            return map;
        }
        finally {
            DiffPropertiesHelper.clear();
        }
    }

    default public void putDiffProperty(String propertyName, Object newValue, Object oldValue) {
        if (null == propertyName || propertyName.isEmpty() || null == newValue) {
            return;
        }
        DiffPropertiesHelper.put(propertyName, newValue, oldValue);
    }
}

