/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.type.MapType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openingo.java.lang.ThreadLocalX;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.lang.StrKit;

public final class JacksonKit {
    private static final ThreadLocalX<JacksonConfig> JACKSON_CONFIG_HOLDER = new ThreadLocalX();
    private static final ThreadLocal<ObjectMapper> OBJECT_MAPPER_HOLDER = ThreadLocal.withInitial(() -> {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        return objectMapper;
    });

    private JacksonKit() {
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = OBJECT_MAPPER_HOLDER.get();
        JacksonConfig jacksonConfig = JACKSON_CONFIG_HOLDER.getRemove();
        if (null != jacksonConfig) {
            if (Objects.nonNull(jacksonConfig.include)) {
                objectMapper.setSerializationInclusion(jacksonConfig.include);
            }
            if (Objects.nonNull(jacksonConfig.datePattern)) {
                objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(jacksonConfig.datePattern));
            }
            if (Objects.nonNull(jacksonConfig.propertyNamingStrategy)) {
                objectMapper.setPropertyNamingStrategy(jacksonConfig.propertyNamingStrategy);
            }
        }
        return objectMapper;
    }

    public static void setConfig(JacksonConfig jacksonConfig) {
        JACKSON_CONFIG_HOLDER.set(jacksonConfig);
    }

    private static void setConfig(JsonInclude.Include include, String datePattern) {
        JacksonConfig jacksonConfig = new JacksonConfig();
        jacksonConfig.include = include;
        jacksonConfig.datePattern = datePattern;
        JacksonKit.setConfig(jacksonConfig);
    }

    public static String toJson(Object object, JacksonConfig jacksonConfig) throws JsonProcessingException {
        JacksonKit.setConfig(jacksonConfig);
        ObjectMapper objectMapper = JacksonKit.getObjectMapper();
        return objectMapper.writeValueAsString(object);
    }

    public static String toJson(Object object, JsonInclude.Include include) throws JsonProcessingException {
        JacksonKit.setConfig(include, null);
        ObjectMapper objectMapper = JacksonKit.getObjectMapper();
        return objectMapper.writeValueAsString(object);
    }

    public static String toJson(Object object, String datePattern, JsonInclude.Include include) throws JsonProcessingException {
        if (StrKit.isBlank(datePattern)) {
            return JacksonKit.toJson(object, include);
        }
        JacksonKit.setConfig(include, datePattern);
        return JacksonKit.getObjectMapper().writeValueAsString(object);
    }

    public static String toJson(Object object) throws JsonProcessingException {
        return JacksonKit.toJson(object, JsonInclude.Include.ALWAYS);
    }

    public static String toJson(Object object, String datePattern) throws JsonProcessingException {
        return JacksonKit.toJson(object, datePattern, JsonInclude.Include.ALWAYS);
    }

    public static <T> T toObj(String json, Class<T> clazz) throws JsonProcessingException {
        if (StrKit.isBlank(json)) {
            return null;
        }
        return (T)JacksonKit.getObjectMapper().readValue(json, clazz);
    }

    public static <T> List<T> toList(String json, Class<? extends List> collectionClass, Class<T> elementClass) throws JsonProcessingException {
        if (StrKit.isBlank(json)) {
            return ListKit.emptyArrayList();
        }
        ObjectMapper objectMapper = JacksonKit.getObjectMapper();
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClass, new Class[]{elementClass});
        return (List)objectMapper.readValue(json, javaType);
    }

    public static <T> List<T> toList(String json, Class<T> elementClass) throws JsonProcessingException {
        return JacksonKit.toList(json, ArrayList.class, elementClass);
    }

    public static <T> List<T[]> to2DList(String json, Class<T[]> clazz) throws JsonProcessingException {
        return JacksonKit.toList(json, clazz);
    }

    public static <K, V> Map<K, V> toMap(String json, Class<? extends Map> mapClass, Class<K> keyClass, Class<V> valueClass) throws JsonProcessingException {
        ObjectMapper objectMapper = JacksonKit.getObjectMapper();
        MapType mapType = objectMapper.getTypeFactory().constructMapType(mapClass, keyClass, valueClass);
        return (Map)objectMapper.readValue(json, (JavaType)mapType);
    }

    public static <K, V> Map<K, V> toMap(Object obj, Class<? extends Map> mapClass, Class<K> keyClass, Class<V> valueClass) throws JsonProcessingException {
        return JacksonKit.toMap(JacksonKit.toJson(obj), mapClass, keyClass, valueClass);
    }

    public static <K, V> Map<K, V> toMap(Object obj, String datePattern, Class<? extends Map> mapClass, Class<K> keyClass, Class<V> valueClass) throws JsonProcessingException {
        return JacksonKit.toMap(JacksonKit.toJson(obj, datePattern), mapClass, keyClass, valueClass);
    }

    public static <K, V> List<Map<K, V>> toMapList(String json, Class<K> keyClass, Class<V> valueClass) throws JsonProcessingException {
        List<Object> objects = JacksonKit.toList(json, List.class, Object.class);
        List<Map<K, V>> list = ListKit.emptyArrayList(objects.size());
        for (Object object : objects) {
            Map<K, V> kvMap = JacksonKit.toMap(JacksonKit.toJson(object), HashMap.class, keyClass, valueClass);
            list.add(kvMap);
        }
        return list;
    }

    public static <K> List<Map<K, Object>> toMapList(String json, Class<K> keyClass) throws JsonProcessingException {
        return JacksonKit.toMapList(json, keyClass, Object.class);
    }

    public static <K, V> LinkedHashMap<K, V> toLinkedMap(String json, Class<K> keyClass, Class<V> valueClass) throws JsonProcessingException {
        ObjectMapper objectMapper = JacksonKit.getObjectMapper();
        MapType mapType = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, keyClass, valueClass);
        return (LinkedHashMap)objectMapper.readValue(json, (JavaType)mapType);
    }

    public static <K, V> List<LinkedHashMap<K, V>> toLinkedMapList(String json, Class<K> keyClass, Class<V> valueClass) throws JsonProcessingException {
        List<Object> objects = JacksonKit.toList(json, List.class, Object.class);
        List<LinkedHashMap<K, V>> list = ListKit.emptyArrayList(objects.size());
        for (Object object : objects) {
            LinkedHashMap<K, V> kvMap = JacksonKit.toLinkedMap(JacksonKit.toJson(object), keyClass, valueClass);
            list.add(kvMap);
        }
        return list;
    }

    public static <K> List<LinkedHashMap<K, Object>> toLinkedMapList(String json, Class<K> keyClass) throws JsonProcessingException {
        return JacksonKit.toLinkedMapList(json, keyClass, Object.class);
    }

    public static class JacksonConfig {
        public JsonInclude.Include include;
        public String datePattern;
        public PropertyNamingStrategy propertyNamingStrategy;
    }
}

