/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.hash;

import java.security.SecureRandom;
import java.util.UUID;
import org.openingo.jdkits.hash.HashKit;

public final class RandomKit {
    private static final Integer NUMBERS = 1;
    private static final Integer CHAR_AND_NUMBERS = 2;

    private RandomKit() {
    }

    public static Integer range(Integer min, Integer max) {
        SecureRandom random = new SecureRandom();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static String uuidStr() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String md5Str() {
        return HashKit.md5(RandomKit.uuidStr());
    }

    public static Integer nInt() {
        return RandomKit.nInt(6);
    }

    public static Integer nInt(Integer randomLen) {
        String random = RandomKit.random(randomLen, NUMBERS);
        random = random.length() < randomLen ? random + "0" : random;
        return Integer.parseInt(random);
    }

    public static String ucStr() {
        return RandomKit.ucStr(8);
    }

    public static String ucStr(Integer randomLen) {
        String random = RandomKit.random(randomLen, CHAR_AND_NUMBERS).toUpperCase();
        return random.length() < randomLen ? random + "0" : random;
    }

    public static String lcStr() {
        return RandomKit.lcStr(8);
    }

    public static String lcStr(Integer randomLen) {
        String random = RandomKit.random(randomLen, CHAR_AND_NUMBERS).toLowerCase();
        return random.length() < randomLen ? random + "0" : random;
    }

    private static String random(Integer randomLen, Integer type) {
        StringBuilder randomRet;
        String dataTable = NUMBERS.equals(type) ? "1234567890" : "1234567890abcdefghijkmnpqrstuvwxyz";
        int dataTableLen = dataTable.length();
        boolean bDone = true;
        do {
            randomRet = new StringBuilder();
            int count = 0;
            for (int i = 0; i < randomLen; ++i) {
                double dblR = Math.random() * (double)dataTableLen;
                int intR = (int)Math.floor(dblR);
                char c = dataTable.charAt(intR);
                if ('0' <= c && c <= '9') {
                    ++count;
                }
                randomRet.append(dataTable.charAt(intR));
            }
            if (count < 2) continue;
            bDone = false;
        } while (bDone);
        return randomRet.toString();
    }
}

