/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.coding;

import java.nio.charset.Charset;
import java.util.Base64;
import javax.xml.bind.DatatypeConverter;

public final class Base64Kit {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static IBase64 delegate = Base64Kit.isPresent("java.util.Base64", Base64Kit.class.getClassLoader()) ? new Java8Base64() : new Java67Base64();

    private Base64Kit() {
    }

    public static String encode(byte[] value) {
        return delegate.encode(value);
    }

    public static String encode(String value) {
        byte[] val = value.getBytes(UTF_8);
        return delegate.encode(val);
    }

    public static String encode(String value, String charsetName) {
        byte[] val = value.getBytes(Charset.forName(charsetName));
        return delegate.encode(val);
    }

    public static byte[] decode(String value) {
        return delegate.decode(value);
    }

    public static String decodeToStr(String value) {
        byte[] decodedValue = delegate.decode(value);
        return new String(decodedValue, UTF_8);
    }

    public static String decodeToStr(String value, String charsetName) {
        byte[] decodedValue = delegate.decode(value);
        return new String(decodedValue, Charset.forName(charsetName));
    }

    private static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, true, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static class Java67Base64
    implements IBase64 {
        Java67Base64() {
        }

        @Override
        public String encode(byte[] data) {
            return DatatypeConverter.printBase64Binary((byte[])data);
        }

        @Override
        public byte[] encode(String value) {
            return DatatypeConverter.printBase64Binary((byte[])value.getBytes()).getBytes();
        }

        @Override
        public byte[] decode(String base64) {
            return DatatypeConverter.parseBase64Binary((String)base64);
        }

        @Override
        public byte[] decode(byte[] value) {
            return DatatypeConverter.parseBase64Binary((String)new String(value));
        }
    }

    static class Java8Base64
    implements IBase64 {
        Java8Base64() {
        }

        @Override
        public String encode(byte[] value) {
            return Base64.getEncoder().encodeToString(value);
        }

        @Override
        public byte[] encode(String value) {
            return Base64.getEncoder().encode(value.getBytes());
        }

        @Override
        public byte[] decode(String value) {
            return Base64.getDecoder().decode(value);
        }

        @Override
        public byte[] decode(byte[] value) {
            return Base64.getDecoder().decode(value);
        }
    }

    static interface IBase64 {
        public String encode(byte[] var1);

        public byte[] encode(String var1);

        public byte[] decode(String var1);

        public byte[] decode(byte[] var1);
    }
}

