/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.java.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class OverrideList<E>
extends ArrayList<E> {
    public OverrideList() {
    }

    public OverrideList(int initialCapacity) {
        super(initialCapacity);
    }

    public OverrideList(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public E set(int index, E element) {
        if (index == -1) {
            super.add(element);
            return element;
        }
        return super.set(index, element);
    }

    @Override
    public boolean add(E e) {
        this.set(this.indexOf(e), e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (this.indexOf(element) != -1) {
            return;
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        c.forEach(this::add);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.removeAll(c.stream().filter(this::contains).collect(Collectors.toList()));
        int size = this.size();
        if (index > size) {
            index = size;
        }
        return super.addAll(index, c);
    }
}

