/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.file;

import java.io.File;
import java.io.InputStream;

public final class PathKit {
    private PathKit() {
    }

    public static String getPath(Class clazz) {
        String path = clazz.getResource("").getPath();
        return new File(path).getAbsolutePath();
    }

    public static String getPath(Object object) {
        String path = object.getClass().getResource("").getPath();
        return new File(path).getAbsolutePath();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : PathKit.class.getClassLoader();
    }

    public static String getPackagePath(Object object) {
        Package p = object.getClass().getPackage();
        return p != null ? p.getName().replaceAll("\\.", "/") : "";
    }

    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/") || path.indexOf(58) == 1;
    }

    public static InputStream getResourceAsStream(String resource) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
    }
}

