/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.tree;

import java.util.Comparator;
import java.util.List;
import org.openingo.jdkits.collection.ListKit;
import org.openingo.jdkits.lang.StrKit;
import org.openingo.jdkits.tree.ITreeNode;
import org.openingo.jdkits.validate.ValidateKit;

public final class TreeParser {
    private TreeParser() {
    }

    public static <E extends ITreeNode<E>> List<E> getTreeList(String rootNodeId, List<E> entityList) {
        return TreeParser.getTreeList(rootNodeId, entityList, true);
    }

    public static <E extends ITreeNode<E>> List<E> getTreeList(String rootNodeId, List<E> entityList, boolean hasRoot) {
        return TreeParser.getTreeList(rootNodeId, entityList, hasRoot, null);
    }

    public static <E extends ITreeNode<E>> List<E> getTreeList(String rootNodeId, List<E> entityList, Comparator<? super E> comparator) {
        return TreeParser.getTreeList(rootNodeId, entityList, true, comparator);
    }

    public static <E extends ITreeNode<E>> List<E> getTreeList(String rootNodeId, List<E> entities, boolean hasRoot, Comparator<? super E> comparator) {
        List<ITreeNode> retTree = ListKit.emptyArrayList();
        if (StrKit.isBlank(rootNodeId)) {
            entities.stream().filter(entity -> StrKit.isBlank(entity.nodeParentId())).forEach(retTree::add);
        } else if (StrKit.equalsAny(rootNodeId, "0", "null")) {
            entities.stream().filter(entity -> rootNodeId.equals(entity.nodeParentId())).forEach(retTree::add);
        } else if (hasRoot) {
            entities.stream().filter(entity -> rootNodeId.equals(entity.nodeId())).forEach(retTree::add);
        } else {
            entities.stream().filter(entity -> rootNodeId.equals(entity.nodeParentId())).forEach(retTree::add);
        }
        if (ValidateKit.isEmpty(retTree)) {
            return retTree;
        }
        if (ValidateKit.isNotNull(comparator)) {
            retTree.sort(comparator);
        }
        retTree.forEach(entity -> entity.loadChildNodes(TreeParser.getChildNodes(entity.nodeId(), entities, comparator)));
        return retTree;
    }

    private static <E extends ITreeNode<E>> List<E> getChildNodes(String nodeParentId, List<E> entityList) {
        return TreeParser.getChildNodes(nodeParentId, entityList, null);
    }

    private static <E extends ITreeNode<E>> List<E> getChildNodes(String nodeParentId, List<E> entityList, Comparator<? super E> comparator) {
        List<ITreeNode> childNodes = ListKit.emptyArrayList();
        entityList.stream().filter(entity -> nodeParentId.equals(entity.nodeParentId())).forEach(childNodes::add);
        if (ValidateKit.isNotNull(comparator)) {
            childNodes.sort(comparator);
        }
        childNodes.forEach(entity -> entity.loadChildNodes(TreeParser.getChildNodes(entity.nodeId(), entityList, comparator)));
        return childNodes;
    }
}

