/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.sys;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.openingo.jdkits.sys.SysKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IPKit {
    private static final Logger logger = LoggerFactory.getLogger(IPKit.class);
    private static final String OBTAIN_IP_ERROR = "unknown";
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final String EMPTY_IP = "0.0.0.0";
    private static final Pattern IP_PATTERN = Pattern.compile("[0-9]{1,3}(\\.[0-9]{1,3}){3,}");

    private IPKit() {
    }

    public static String getServerIp() {
        String sysType = SysKit.getOSType();
        String ip = OBTAIN_IP_ERROR;
        if ("windows".equals(sysType)) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else if ("linux".equals(sysType)) {
            ip = IPKit.getIpByEthId("eth0");
        } else if ("macOS".equals(sysType)) {
            ip = IPKit.getIpByEthId("en0");
        }
        return ip;
    }

    private static String getIpByEthId(String ethId) {
        String ip = OBTAIN_IP_ERROR;
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (!ethId.equals(netInterface.getName())) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ipAddress = addresses.nextElement();
                    if (!ValidateKit.isNotNull(ipAddress) || !(ipAddress instanceof Inet4Address)) continue;
                    return ipAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String getRequestIP(HttpServletRequest request) {
        String unknown = OBTAIN_IP_ERROR;
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ipAddress == null || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        if (ipAddress != null && ipAddress.contains(",")) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(",")).trim();
        }
        if ("0:0:0:0:0:0:0:1".equals(ipAddress)) {
            ipAddress = IPKit.getHostIp();
        }
        if (null == ipAddress) {
            ipAddress = LOCALHOST_IP;
        }
        return ipAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailablePort(int port) {
        try (ServerSocket ss = new ServerSocket(port);){
            ss.bind(null);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isValidHostAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !EMPTY_IP.equals(name) && !LOCALHOST_IP.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static String getHostIp() {
        InetAddress address = IPKit.getHostAddress();
        return address == null ? null : address.getHostAddress();
    }

    public static String getHostName() {
        InetAddress address = IPKit.getHostAddress();
        return address == null ? null : address.getHostName();
    }

    public static boolean isHostIp(String ip) {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (localAddress.isLoopbackAddress() || IPKit.isValidHostAddress(localAddress) && (localAddress.getHostAddress().equals(ip) || localAddress.getHostName().equals(ip))) {
                return true;
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to retriving local host ip address, try scan network card ip address. cause: " + e.getMessage());
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        if (addresses == null) continue;
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!address.isLoopbackAddress() && (!IPKit.isValidHostAddress(address) || !address.getHostAddress().equals(ip))) continue;
                                return true;
                            }
                            catch (Throwable e) {
                                logger.warn("Failed to retriving network card ip address. cause:" + e.getMessage());
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.warn("Failed to retriving network card ip address. cause:" + e.getMessage());
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to retriving network card ip address. cause:" + e.getMessage());
        }
        return false;
    }

    public static InetAddress getHostAddress() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (IPKit.isValidHostAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to retriving local host ip address, try scan network card ip address. cause: " + e.getMessage());
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        if (addresses == null) continue;
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!IPKit.isValidHostAddress(address)) continue;
                                return address;
                            }
                            catch (Throwable e) {
                                logger.warn("Failed to retriving network card ip address. cause:" + e.getMessage());
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.warn("Failed to retriving network card ip address. cause:" + e.getMessage());
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to retriving network card ip address. cause:" + e.getMessage());
        }
        logger.error("Could not get local host ip address, will use 127.0.0.1 instead.");
        return localAddress;
    }
}

