/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.jdkits.hash;

import org.openingo.jdkits.lang.StrKit;

public final class HexKit {
    private HexKit() {
    }

    public static byte[] HexStringToBytes(String hexString) {
        if (StrKit.isBlank(hexString)) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            data[i] = (byte)(HexKit.c2b(hexChars[pos]) << 4 | HexKit.c2b(hexChars[pos + 1]));
        }
        return data;
    }

    private static byte c2b(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String byteToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }
}

