/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.idempotent.store;

import org.openingo.jdkits.json.JacksonKit;
import org.openingo.spring.boot.extension.data.redis.RedisTemplateX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class IdempotentStore
extends RedisTemplateX<String, String> {
    private static final Logger log = LoggerFactory.getLogger(IdempotentStore.class);

    public IdempotentStore(StringRedisTemplate stringRedisTemplate) {
        super(stringRedisTemplate);
    }

    public Object getData(String idempotentKey, Class<?> dataType) throws Throwable {
        String key = this.key(idempotentKey);
        log.info("get data key {}", (Object)key);
        String data = (String)this.get(key);
        return JacksonKit.toObj((String)data, dataType);
    }

    public void saveData(String idempotentKey, Object data, Long expireMinutes) throws Throwable {
        String key = this.key(idempotentKey);
        log.info("save data key {} expireMinutes {}", (Object)key, (Object)expireMinutes);
        this.setNx(key, JacksonKit.toJson((Object)data), expireMinutes * 1000L);
    }

    private String key(String idempotentKey) {
        return String.format("Idempotent-Data:%s", idempotentKey);
    }
}

