/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.http.request.error;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openingo.java.lang.ThreadLocalX;
import org.openingo.jdkits.lang.ObjectKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.boot.extension.http.config.HttpRequestLogConfigProperties;
import org.openingo.spring.boot.extension.http.request.HttpRequestReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public class DefaultErrorAttributesX
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorAttributesX.class);
    @Autowired
    HttpRequestLogConfigProperties httpRequestLogConfigProperties;
    private final ThreadLocalX<Object> HANDLER_HOLDER = new ThreadLocalX();
    private final ThreadLocalX<Exception> EXCEPTION_HOLDER = new ThreadLocalX();
    private final boolean usingException;

    public DefaultErrorAttributesX() {
        this(false);
    }

    public DefaultErrorAttributesX(boolean usingException) {
        super(true);
        this.usingException = usingException;
    }

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        Map errorAttributes = super.getErrorAttributes(webRequest, includeStackTrace);
        Object handler = this.HANDLER_HOLDER.getRemove();
        if (ValidateKit.isNotNull((Object)handler)) {
            errorAttributes.put("handler", handler.toString());
        }
        return errorAttributes;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        this.HANDLER_HOLDER.set(handler);
        if (this.usingException) {
            this.EXCEPTION_HOLDER.set((Object)exception);
        }
        if (this.httpRequestLogConfigProperties.isEnable()) {
            HttpRequestReporter httpRequestReporter = HttpRequestReporter.getInstance();
            httpRequestReporter.setRequest(request);
            httpRequestReporter.setException(exception);
            if (ValidateKit.isNotNull((Object)handler)) {
                httpRequestReporter.setHandler((HandlerMethod)handler);
            }
            httpRequestReporter.report();
            StringBuilder errorBuilder = new StringBuilder();
            log.error(errorBuilder.append("\n****************************************************************\n:: SpringApplicationX :: for current request report information \n****************************************************************\n").toString());
        }
        return super.resolveException(request, response, handler, exception);
    }

    protected Exception getHandlerExecutionException() {
        if (!this.usingException) {
            throw new IllegalStateException("\"usingException\" state is Illegal, required true state.");
        }
        return (Exception)this.EXCEPTION_HOLDER.getRemove();
    }

    protected Integer getStatus(Map<String, Object> errorAttributes) {
        return ObjectKit.toInteger((Object)errorAttributes.get("status"));
    }

    protected String getError(Map<String, Object> errorAttributes) {
        return errorAttributes.get("error").toString();
    }

    @Deprecated
    protected String getMessage(Map<String, Object> errorAttributes) {
        return errorAttributes.get("message").toString();
    }

    protected boolean responseOK(Map<String, Object> errorAttributes) {
        return HttpStatus.OK.value() == this.getStatus(errorAttributes).intValue();
    }
}

