/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.gedid.engine.snowflake;

import org.openingo.jdkits.sys.SystemClockKit;
import org.openingo.spring.boot.exception.DidException;

public class Snowflake {
    private static final Long TWEPOCH = 1420041600000L;
    private static final Long WORKER_ID_BITS = 5L;
    private static final Long DATA_CENTER_ID_BITS = 5L;
    private static final Long MAX_WORKER_ID = -1L << (int)WORKER_ID_BITS.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
    private static final Long MAX_DATA_CENTER_ID = -1L << (int)DATA_CENTER_ID_BITS.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
    private static final Long SEQUENCE_BITS;
    private static final Long WORKER_ID_SHIFT;
    private static final Long DATA_CENTER_ID_SHIFT;
    private static final Long TIMESTAMP_LEFT_SHIFT;
    private static final Long SEQUENCE_MASK;
    private final Long workerId;
    private final Long dataCenterId;
    private Long sequence = 0L;
    private Long lastTimestamp = -1L;

    public Snowflake(Long workerId, Long dataCenterId) {
        if (workerId > MAX_WORKER_ID || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", MAX_WORKER_ID));
        }
        if (dataCenterId > MAX_DATA_CENTER_ID || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", MAX_DATA_CENTER_ID));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public Long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new DidException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & SEQUENCE_MASK;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - TWEPOCH << (int)TIMESTAMP_LEFT_SHIFT.longValue() | this.dataCenterId << (int)DATA_CENTER_ID_SHIFT.longValue() | this.workerId << (int)WORKER_ID_SHIFT.longValue() | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return SystemClockKit.now();
    }

    static {
        WORKER_ID_SHIFT = SEQUENCE_BITS = Long.valueOf(12L);
        DATA_CENTER_ID_SHIFT = SEQUENCE_BITS + WORKER_ID_BITS;
        TIMESTAMP_LEFT_SHIFT = SEQUENCE_BITS + WORKER_ID_BITS + DATA_CENTER_ID_BITS;
        SEQUENCE_MASK = -1L << (int)SEQUENCE_BITS.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

