/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.gedid.engine.redis;

import java.util.Objects;
import org.openingo.spring.boot.extension.data.redis.RedisTemplateX;
import org.openingo.spring.boot.extension.gedid.engine.IDidEngine;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisIdEngine
extends RedisTemplateX<String, String>
implements IDidEngine<Long> {
    public RedisIdEngine(StringRedisTemplate stringRedisTemplate) {
        super(stringRedisTemplate);
    }

    @Override
    public void follow(String businessName, Long startId) {
        startId = startId - 1L;
        this.setNx(this.getEmbellishedName(businessName), startId.toString());
    }

    @Override
    public String getEmbellishedName(String businessName) {
        return String.format("%s:%s", "gedid", businessName);
    }

    @Override
    public Long getFixedStartId(Long startId) {
        if (Objects.isNull(startId)) {
            return 1L;
        }
        if (startId < 0L) {
            startId = 1L;
        }
        return startId;
    }

    @Override
    public Long next(String businessName) {
        return this.incr(this.getEmbellishedName(businessName));
    }

    @Override
    public String engineName() {
        return "redis";
    }
}

