/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.gedid.config;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.lettuce.core.RedisClient;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.openingo.spring.boot.extension.gedid.config.EtcdIdEngineConfigProperties;
import org.openingo.spring.boot.extension.gedid.config.JedisConnectionConfiguration;
import org.openingo.spring.boot.extension.gedid.config.LettuceConnectionConfiguration;
import org.openingo.spring.boot.extension.gedid.config.RedisConnectionConfiguration;
import org.openingo.spring.boot.extension.gedid.config.ZookeeperIdEngineConfigProperties;
import org.openingo.spring.boot.extension.gedid.engine.etcd.EtcdIdEngine;
import org.openingo.spring.boot.extension.gedid.engine.redis.RedisIdEngine;
import org.openingo.spring.boot.extension.gedid.engine.snowflake.SnowflakeIdEngine;
import org.openingo.spring.boot.extension.gedid.engine.uuid.UuidEngine;
import org.openingo.spring.boot.extension.gedid.engine.zookeeper.ZookeeperIdEngine;
import org.openingo.spring.boot.extension.gedid.engine.zookeeper.ZookeeperIdEngineMode;
import org.openingo.spring.boot.extension.gedid.loader.DidLoader;
import org.openingo.spring.boot.extension.gedid.loader.DidLoaderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.zookeeper.ZookeeperAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@Import(value={DidLoaderConfiguration.class})
public class GeDidConfig {
    @Bean
    DidLoader didLoader() {
        return new DidLoader();
    }

    @Configuration
    @ConditionalOnClass(value={Client.class})
    @EnableConfigurationProperties(value={EtcdIdEngineConfigProperties.class})
    static class EtcdConfig {
        EtcdConfig() {
        }

        @Bean(destroyMethod="close")
        EtcdIdEngine etcdIdEngine(EtcdIdEngineConfigProperties properties) {
            String password;
            ClientBuilder clientBuilder = Client.builder().endpoints(properties.getEndpoints().toArray(new String[0]));
            String user = properties.getUser();
            if (StringUtils.isNotBlank((String)user)) {
                clientBuilder.user(ByteSequence.from((byte[])user.getBytes(StandardCharsets.UTF_8)));
            }
            if (StringUtils.isNotBlank((String)(password = properties.getPassword()))) {
                clientBuilder.password(ByteSequence.from((byte[])password.getBytes(StandardCharsets.UTF_8)));
            }
            Client etcdClient = clientBuilder.build();
            return new EtcdIdEngine(etcdClient);
        }
    }

    @Configuration
    static class SnowflakeConfig {
        SnowflakeConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        SnowflakeIdEngine snowflakeIdEngine() {
            return new SnowflakeIdEngine();
        }
    }

    @Configuration
    static class UuidEngineConfig {
        UuidEngineConfig() {
        }

        @Bean
        UuidEngine uuidEngine() {
            return new UuidEngine();
        }
    }

    @Configuration
    @ConditionalOnClass(value={CuratorFramework.class, RetryPolicy.class, ZookeeperAutoConfiguration.class})
    @EnableConfigurationProperties(value={ZookeeperIdEngineConfigProperties.class})
    static class ZookeeperIdEngineConfig {
        private static final Logger log = LoggerFactory.getLogger(ZookeeperIdEngineConfig.class);

        ZookeeperIdEngineConfig() {
        }

        @Bean(destroyMethod="close")
        ZookeeperIdEngine zookeeperIdEngine(ZookeeperIdEngineConfigProperties properties, ZookeeperIdEngineMode mode) {
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
            builder.connectString(properties.getConnectString());
            RetryPolicy retryPolicy = this.exponentialBackoffRetry(properties);
            CuratorFramework curator = builder.retryPolicy(retryPolicy).build();
            curator.start();
            String connectString = properties.getConnectString();
            String name = ZookeeperIdEngine.class.getSimpleName();
            log.info("`{}` blocking until connected to zookeeper at {} for " + properties.getBlockUntilConnectedWait() + (Object)((Object)properties.getBlockUntilConnectedUnit()), (Object)name, (Object)connectString);
            try {
                curator.blockUntilConnected(properties.getBlockUntilConnectedWait().intValue(), properties.getBlockUntilConnectedUnit());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                log.error(e.getLocalizedMessage());
            }
            log.info("`{}` connected to zookeeper at {}", (Object)name, (Object)connectString);
            return new ZookeeperIdEngine(curator, mode);
        }

        private RetryPolicy exponentialBackoffRetry(ZookeeperIdEngineConfigProperties properties) {
            return new ExponentialBackoffRetry(properties.getBaseSleepTimeMs().intValue(), properties.getMaxRetries().intValue(), properties.getMaxSleepMs().intValue());
        }

        @Bean
        @ConditionalOnMissingBean
        public ZookeeperIdEngineMode zookeeperIdEngineMode() {
            return ZookeeperIdEngineMode.DATA_VERSION;
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisOperations.class, RedisClient.class})
    @Import(value={LettuceConnectionConfiguration.class, JedisConnectionConfiguration.class})
    static class RedisIdEngineConfig {
        RedisIdEngineConfig() {
        }

        @Bean
        RedisIdEngine redisIdEngine(RedisConnectionConfiguration configuration) {
            StringRedisTemplate template = new StringRedisTemplate();
            template.setConnectionFactory(configuration.redisConnectionFactory());
            template.afterPropertiesSet();
            return new RedisIdEngine(template);
        }
    }
}

