/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.datasource.provider;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.openingo.jdkits.lang.StrKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.boot.extension.datasource.provider.IDataSourceProvider;

public class DruidDataSourceProvider
extends DruidDataSource
implements IDataSourceProvider {
    private String providerName = null;
    private String publicKey;
    private String filters;
    private volatile boolean isStarted = false;
    private DruidDataSource cloneInstance = null;

    private static String autoCheckValidationQuery(String url) {
        if (url.startsWith("jdbc:oracle")) {
            return "select 1 from dual";
        }
        if (url.startsWith("jdbc:db2")) {
            return "select 1 from sysibm.sysdummy1";
        }
        if (url.startsWith("jdbc:hsqldb")) {
            return "select 1 from INFORMATION_SCHEMA.SYSTEM_USERS";
        }
        if (url.startsWith("jdbc:derby")) {
            return "select 1 from INFORMATION_SCHEMA.SYSTEM_USERS";
        }
        return "select 1";
    }

    private DruidDataSource deduceDataSource() {
        if (ValidateKit.isNotNull((Object)this.cloneInstance)) {
            return this.cloneInstance;
        }
        return this;
    }

    private DruidDataSourceProvider() {
        super.setInitialSize(1);
        super.setMinIdle(10);
        super.setMaxActive(32);
        super.setMaxWait(-1L);
        super.setTimeBetweenEvictionRunsMillis(60000L);
        super.setMinEvictableIdleTimeMillis(1800000L);
        super.setTimeBetweenConnectErrorMillis(500L);
        super.setTestWhileIdle(true);
        super.setTestOnBorrow(false);
        super.setTestOnReturn(false);
        super.setRemoveAbandoned(false);
        super.setRemoveAbandonedTimeoutMillis(300000L);
        super.setLogAbandoned(false);
        super.setPoolPreparedStatements(true);
        super.setMaxPoolPreparedStatementPerConnectionSize(-1);
    }

    public DruidDataSourceProvider(DruidDataSource dataSource) {
        this.cloneInstance = dataSource;
    }

    public DruidDataSourceProvider(String url, String username, String password) {
        this();
        super.setUrl(url);
        super.setUsername(username);
        super.setPassword(password);
        super.setValidationQuery(DruidDataSourceProvider.autoCheckValidationQuery(url));
    }

    public DruidDataSourceProvider(String url, String username, String password, String driverClass) {
        this(url, username, password);
        super.setDriverClassName(driverClass);
    }

    public DruidDataSourceProvider(String url, String username, String password, String driverClass, String filters) {
        this(url, username, password, driverClass);
        this.setFilters(filters);
    }

    public void setProviderName(String name) {
        this.providerName = name;
    }

    public void set(int initialSize, int minIdle, int maxActive) {
        DruidDataSource dataSource = this.deduceDataSource();
        dataSource.setInitialSize(initialSize);
        dataSource.setMinIdle(minIdle);
        dataSource.setMaxActive(maxActive);
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setConnectionInitSqls(String ... sqls) {
        this.deduceDataSource().setConnectionInitSqls(Arrays.asList(sqls));
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    @Override
    public boolean startProviding() {
        if (this.isStarted) {
            return true;
        }
        if (StrKit.notBlank((CharSequence)this.filters)) {
            Properties connectProperties = null;
            if (this.filters.contains("config")) {
                if (StrKit.isBlank((CharSequence)this.publicKey)) {
                    throw new DruidRuntimeException("Druid setting the config filter, publicKey required.");
                }
                connectProperties = this.getConnectProperties();
                if (ValidateKit.isNull((Object)connectProperties)) {
                    connectProperties = new Properties();
                }
                connectProperties.setProperty("config.decrypt", "true");
                connectProperties.setProperty("config.decrypt.key", this.publicKey);
            }
            try {
                if (ValidateKit.isNotNull((Object)this.cloneInstance)) {
                    this.cloneInstance.setFilters(this.filters);
                    this.cloneInstance.setConnectProperties(connectProperties);
                } else {
                    super.setFilters(this.filters);
                    super.setConnectProperties(connectProperties);
                }
            }
            catch (SQLException e) {
                throw new DruidRuntimeException((Throwable)e);
            }
        }
        this.isStarted = true;
        return true;
    }

    @Override
    public boolean destroy() {
        this.deduceDataSource().close();
        this.isStarted = false;
        return true;
    }

    @Override
    public DataSource getDataSource() {
        return this.deduceDataSource();
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    public DruidDataSource cloneDruidDataSource() {
        if (ValidateKit.isNotNull((Object)this.cloneInstance)) {
            return this.cloneInstance.cloneDruidDataSource();
        }
        return super.cloneDruidDataSource();
    }
}

