/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.openingo.jdkits.lang.StrKit;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.boot.SpringBootVersionX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public final class SpringApplicationX {
    private static final Logger log = LoggerFactory.getLogger(SpringApplicationX.class);
    public static SpringApplication springApplication;
    public static ConfigurableApplicationContext applicationContext;
    public static boolean isDebugging;
    public static ConfigurableEnvironment environment;
    public static Class<?> mainApplicationClass;
    public static String applicationPackage;
    public static String springBootVersion;
    public static String springBootVersionX;
    public static boolean isRunningAsJar;
    private static final String CP_CONFIG_ARG = "ccp";
    private static File applicationHomeSource;

    private static boolean isDebugging() {
        List<String> envs = Arrays.asList(environment.getActiveProfiles());
        return !envs.contains("prod");
    }

    private static void preInitSpringApplicationX(Class<?>[] primarySources) {
        springApplication = new SpringApplication((Class[])primarySources);
        mainApplicationClass = springApplication.getMainApplicationClass();
        applicationPackage = mainApplicationClass.getPackage().getName();
        ApplicationHome applicationHome = new ApplicationHome(mainApplicationClass);
        applicationHomeSource = applicationHome.getSource();
        if (applicationHomeSource != null) {
            String absolutePath = applicationHomeSource.getAbsolutePath();
            isRunningAsJar = absolutePath.endsWith("jar");
        }
    }

    private static void initSpringApplicationX(String[] args) {
        applicationContext = springApplication.run(args);
        environment = applicationContext.getEnvironment();
        isDebugging = SpringApplicationX.isDebugging();
    }

    private static void copyConfigsInJar() throws IOException {
        if (!isRunningAsJar) {
            return;
        }
        String configPath = "config/";
        File config = new File(System.getProperty("user.dir") + "/" + "config/");
        if (config.exists() || !config.mkdir()) {
            System.out.println("==the configs is exist or create config path error.==");
            return;
        }
        System.out.println("==starting copy configs.==");
        JarFile jarFile = new JarFile(applicationHomeSource);
        HashSet<String> configFiles = new HashSet<String>(){
            {
                this.add(".properties");
                this.add(".yaml");
                this.add(".yml");
                this.add(".xml");
            }
        };
        int copyFileCount = 0;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            boolean isConfig = false;
            int lastIndexOf = entryName.indexOf("config/");
            String outPath = "";
            if (lastIndexOf != -1) {
                outPath = entryName.substring(lastIndexOf);
                isConfig = true;
            } else {
                lastIndexOf = entryName.lastIndexOf(".");
                if (lastIndexOf != -1) {
                    String file = entryName.substring(entryName.lastIndexOf("/") + 1);
                    boolean pomFile = "pom.properties".equals(file) || "pom.xml".equals(file);
                    boolean bl = isConfig = configFiles.contains(entryName.substring(lastIndexOf)) && !pomFile;
                    if (isConfig) {
                        outPath = String.join((CharSequence)"", "config/", file);
                    }
                }
            }
            if (!isConfig) continue;
            InputStream jarFileInputStream = jarFile.getInputStream(entry);
            File currentFile = new File(outPath.substring(0, outPath.lastIndexOf(47)));
            if (!currentFile.exists() && !currentFile.mkdirs() || new File(outPath).isDirectory()) continue;
            ++copyFileCount;
            System.out.println("==copy \"" + entryName + "\" to \"" + outPath + "\"==");
            FileOutputStream out = new FileOutputStream(outPath);
            byte[] bytes = new byte[1024];
            while ((len = jarFileInputStream.read(bytes)) > 0) {
                out.write(bytes, 0, len);
            }
            jarFileInputStream.close();
            out.close();
        }
        System.out.println("==copy \"" + copyFileCount + "\" files.==");
        System.out.println("==copy configs finished.==");
    }

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        return SpringApplicationX.run(new Class[]{primarySource}, args);
    }

    public static ConfigurableApplicationContext run(Class<?>[] primarySources, String[] args) {
        SpringApplicationX.preInitSpringApplicationX(primarySources);
        if (ValidateKit.isNotEmpty((Object)args) && args.length == 1 && CP_CONFIG_ARG.equals(args[0])) {
            SpringApplicationX.copyConfigsInJar();
            return null;
        }
        SpringApplicationX.initSpringApplicationX(args);
        SpringApplicationX.applicationInfo();
        return applicationContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)applicationContext.getBean(clazz);
    }

    public static void applicationInfo() {
        String infoBuilder = "\n=======Application Info========\n" + String.format(" SpringBootVersion: %s\n", springBootVersion) + String.format(" SpringBootVersionX: %s\n", springBootVersionX) + String.format(" ApplicationPackage: %s\n", applicationPackage) + String.format(" MainApplicationClass: %s\n", mainApplicationClass.getName()) + String.format(" RunningAsJar: %s\n", isRunningAsJar) + String.format(" isDebugging: %s\n", isDebugging) + String.format(" Server.port: %s\n", StrKit.defaultIfBlank((String)environment.getProperty("server.port"), (String)"8080")) + String.format(" Client.ip-address: %s\n", StrKit.defaultIfBlank((String)environment.getProperty("spring.cloud.client.ip-address"), (String)"127.0.0.1")) + String.format(" User.dir: %s\n", environment.getProperty("user.dir")) + "===============================\n";
        log.info(infoBuilder);
    }

    static {
        isDebugging = false;
        environment = null;
        mainApplicationClass = null;
        applicationPackage = null;
        springBootVersion = SpringBootVersion.getVersion();
        springBootVersionX = SpringBootVersionX.getVersion();
        isRunningAsJar = false;
    }
}

