/*
 * MIT License
 *
 * Copyright (c) 2021 OpeningO Co.,Ltd.
 *
 *    https://openingo.org
 *    contactus(at)openingo.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.openingo.spring.boot.extension.data.elasticsearch.builder.index;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.openingo.jdkits.json.JacksonKit;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * MappingsProperties
 *
 * @author Qicz
 */
public final class MappingsProperties implements Serializable {

    private Map<String, Object> properties = new HashMap<>();

    private MappingsProperties() {}

    public static MappingsProperties me() {
        return new MappingsProperties();
    }

    public MappingsProperties add(MappingsProperty property) {
        String name = property.name();
        Assert.hasText(name, "the property name must not be null!");
        this.properties.put(name, property);
        return this;
    }

    public String toJson() throws JsonProcessingException {
        Map<String, Object> properties = new HashMap<>();
        properties.put("properties", this.properties);
        return JacksonKit.toJson(properties);
    }
}
