/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.minio.config;

import io.minio.MinioClient;
import org.openingo.spring.boot.extension.minio.MinioClientX;
import org.openingo.spring.boot.extension.minio.config.MinioConfigProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="openingo.minio", name={"enable"}, havingValue="true")
@ConditionalOnClass(value={MinioClient.class})
@EnableConfigurationProperties(value={MinioConfigProperties.class})
public class MinioConfig {
    @Bean
    @ConditionalOnMissingBean
    public MinioClient minioClient(MinioConfigProperties minioConfigProperties) {
        return MinioClient.builder().endpoint(minioConfigProperties.getEndpoint()).credentials(minioConfigProperties.getAccessKey(), minioConfigProperties.getSecretKey()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public MinioClientX minioClientX(MinioClient minioClient, MinioConfigProperties minioConfigProperties) {
        return new MinioClientX(minioClient, minioConfigProperties);
    }
}

