/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.minio;

import io.minio.MinioClient;
import io.minio.PostPolicy;
import java.time.ZonedDateTime;
import java.util.Map;
import org.openingo.spring.boot.extension.minio.config.MinioConfigProperties;
import org.springframework.util.Assert;

public class MinioClientX
extends MinioClient {
    private final MinioConfigProperties minioConfigProperties;

    public MinioClientX(MinioClient client, MinioConfigProperties minioConfigProperties) {
        super(client);
        this.minioConfigProperties = minioConfigProperties;
    }

    public Map<String, String> getPresignedPostFormData(String objectName) {
        String allowFileTypes = this.minioConfigProperties.getAllowFileTypes().toLowerCase();
        int idx = objectName.lastIndexOf(".");
        Assert.isTrue((-1 != idx ? 1 : 0) != 0, (String)"file extension is unknown");
        String fileType = objectName.substring(idx + 1).toLowerCase();
        Assert.isTrue((boolean)allowFileTypes.contains(fileType), (String)String.format("the \"%s\" file is not allow", fileType));
        String bucket = this.minioConfigProperties.getBucket();
        Integer uploadExpireSeconds = this.minioConfigProperties.getUploadExpireSeconds();
        Integer allowMinSize = this.minioConfigProperties.getAllowMinSize();
        Integer allowMaxSize = this.minioConfigProperties.getAllowMaxSize();
        PostPolicy policy = new PostPolicy(bucket, ZonedDateTime.now().plusSeconds(uploadExpireSeconds.intValue()));
        policy.addEqualsCondition("key", objectName);
        policy.addContentLengthRangeCondition(allowMinSize.intValue(), allowMaxSize.intValue());
        return this.getPresignedPostFormData(policy);
    }
}

