/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.gedid.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openingo.spring.boot.exception.DidException;
import org.openingo.spring.boot.extension.gedid.engine.IDidEngine;
import org.openingo.spring.boot.kit.safety.Safety;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DidLoader {
    private static final Logger log = LoggerFactory.getLogger(DidLoader.class);
    private final Safety safety = new Safety();
    private final Map<String, IDidEngine> engineMapping = new HashMap<String, IDidEngine>();
    private final Map<String, IDidEngine> businessEngineMapping = new HashMap<String, IDidEngine>();

    protected void addEngine(IDidEngine<?> engine) {
        String engineName = engine.engineName();
        if (!this.engineMapping.containsKey(engineName)) {
            this.engineMapping.put(engineName, engine);
        }
    }

    public void follow(String businessUri) {
        this.follow(this.getUri(businessUri), null);
    }

    public <T> void follow(String businessUri, T startId) {
        this.follow(this.getUri(businessUri), startId);
    }

    public <T> void follow(URI businessUri) {
        this.follow(businessUri.getScheme(), businessUri.getHost());
    }

    public <T> void follow(URI businessUri, T startId) {
        this.follow(businessUri.getScheme(), businessUri.getHost(), startId);
    }

    public void follow(String engineName, String businessName) {
        this.follow(engineName, businessName, null);
    }

    public <T> void follow(String engineName, String businessName, T startId) {
        if (!this.engineMapping.containsKey(engineName)) {
            log.info("the engine `{}` is not exist.", (Object)engineName);
            return;
        }
        IDidEngine engine = this.engineMapping.get(engineName);
        if (this.businessEngineMapping.containsKey(businessName)) {
            String message = String.format("the engine `%s` is following this business `%s`", this.businessEngineMapping.get(businessName).engineName(), businessName);
            throw new DidException(message);
        }
        this.businessEngineMapping.put(businessName, engine);
        Object fixedStartId = engine.getFixedStartId(startId);
        this.safety.safetyRun(() -> engine.follow(businessName, fixedStartId));
        log.info("`{}` engine following the business `{}` and startId is `{}`", new Object[]{engineName, businessName, fixedStartId});
    }

    public Long nextToLong(String businessName) {
        return (Long)this.next(businessName);
    }

    public String nextToString(String businessName) {
        return this.next(businessName).toString();
    }

    public <T> T next(String businessName) {
        IDidEngine engine = this.businessEngineMapping.get(businessName);
        if (Objects.isNull(engine)) {
            String message = String.format("the engine for business `%s` is not exist.", businessName);
            throw new DidException(message);
        }
        Object nextId = this.safety.safetyCall(() -> engine.next(businessName));
        log.info("`{}` engine following the business `{}` and the nextId is `{}`", new Object[]{engine.engineName(), businessName, nextId});
        return (T)nextId;
    }

    private URI getUri(String uriString) {
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            log.error("the uri `{}` is malformed", (Object)uriString);
        }
        return uri;
    }
}

