/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.gedid.engine.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.data.Stat;
import org.openingo.spring.boot.exception.DidException;
import org.openingo.spring.boot.extension.gedid.engine.IDidEngine;
import org.openingo.spring.boot.extension.gedid.engine.zookeeper.ZookeeperIdEngineMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperIdEngine
implements IDidEngine<Long> {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperIdEngine.class);
    private final CuratorFramework curator;
    private Long startId;
    private final ZookeeperIdEngineMode zookeeperIdEngineMode;

    public ZookeeperIdEngine(CuratorFramework curator, ZookeeperIdEngineMode zookeeperIdEngineMode) {
        this.curator = curator;
        this.zookeeperIdEngineMode = zookeeperIdEngineMode;
        log.info("starting with mode `{}`", (Object)zookeeperIdEngineMode);
    }

    @Override
    public void follow(String businessName, Long startId) {
        this.startId = startId;
        String path = this.getPath(businessName);
        try {
            Stat stat = (Stat)this.curator.checkExists().forPath(path);
            if (Objects.isNull(stat)) {
                this.curator.create().forPath(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getEmbellishedName(String businessName) {
        return String.format("/%s-%s", "gedid", businessName);
    }

    @Override
    public Long getFixedStartId(Long startId) {
        if (Objects.isNull(startId)) {
            return 1L;
        }
        if (startId < 0L) {
            return 1L;
        }
        return startId;
    }

    @Override
    public Long next(String businessName) {
        String path = this.getPath(businessName);
        long id = -1L;
        try {
            Stat stat = (Stat)this.curator.setData().forPath(path, "".getBytes(StandardCharsets.UTF_8));
            id = stat.getVersion();
            if (ZookeeperIdEngineMode.DATA_ZX_MID.equals((Object)this.zookeeperIdEngineMode)) {
                id = stat.getMzxid() - stat.getCzxid();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
            throw new DidException(e.getLocalizedMessage());
        }
        return id += this.startId.longValue();
    }

    @Override
    public String engineName() {
        return "zookeeper";
    }

    private String getPath(String name) {
        return this.getEmbellishedName(name);
    }

    private void close() {
        String name = this.engineName();
        log.info("the `{}` engine is closing...", (Object)name);
        this.curator.close();
        log.info("the `{}` engine is closed", (Object)name);
    }
}

