/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.gedid.engine.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.options.PutOption;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.openingo.spring.boot.exception.DidException;
import org.openingo.spring.boot.extension.gedid.engine.IDidEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdIdEngine
implements IDidEngine<Long> {
    private static final Logger log = LoggerFactory.getLogger(EtcdIdEngine.class);
    private final Client etcdClient;
    private final KV kvClient;
    private Long startId;

    public EtcdIdEngine(Client etcdClient) {
        this.etcdClient = etcdClient;
        this.kvClient = etcdClient.getKVClient();
    }

    @Override
    public void follow(String businessName, Long startId) {
        this.startId = startId + 1L;
    }

    @Override
    public String getEmbellishedName(String businessName) {
        return String.format("%s-%s", "gedid", businessName);
    }

    @Override
    public Long getFixedStartId(Long startId) {
        if (Objects.isNull(startId)) {
            return 1L;
        }
        if (startId < 0L) {
            startId = 1L;
        }
        return startId;
    }

    @Override
    public Long next(String businessName) {
        long id = -1L;
        try {
            PutOption putOption = PutOption.newBuilder().withPrevKV().build();
            PutResponse putResponse = (PutResponse)this.kvClient.put(this.toByteSequence(this.getEmbellishedName(businessName)), this.toByteSequence(""), putOption).get();
            id = putResponse.getPrevKv().getVersion() + this.startId;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getLocalizedMessage());
            throw new DidException(e.getLocalizedMessage());
        }
        return id;
    }

    @Override
    public String engineName() {
        return "etcd";
    }

    private ByteSequence toByteSequence(String data) {
        return ByteSequence.from((byte[])data.getBytes(StandardCharsets.UTF_8));
    }

    private void close() {
        String name = this.engineName();
        log.info("the `{}` engine is closing...", (Object)name);
        this.etcdClient.close();
        log.info("the `{}` engine is closed", (Object)name);
    }
}

