/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.datasource.tx;

import org.openingo.spring.boot.extension.datasource.tx.TxCallable;
import org.openingo.spring.boot.extension.datasource.tx.TxRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

public class ManualTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(ManualTransactionManager.class);
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition;

    public ManualTransactionManager(PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        this.transactionManager = transactionManager;
        this.transactionDefinition = transactionDefinition;
    }

    public void txRun(TxRunnable runnable) {
        TransactionStatus transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        try {
            runnable.run();
            this.transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            this.transactionManager.rollback(transactionStatus);
        }
    }

    public <T> T txCall(TxCallable<T> callable) {
        TransactionStatus transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
        T ret = null;
        try {
            ret = callable.call();
            this.transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            this.transactionManager.rollback(transactionStatus);
        }
        return ret;
    }
}

