/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.datasource.routing;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.boot.extension.datasource.holder.RoutingDataSourceHolder;
import org.openingo.spring.boot.extension.datasource.provider.IDataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RoutingDataSource
extends AbstractDataSource
implements DataSource,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RoutingDataSource.class);
    @Nullable
    private ConcurrentHashMap<Object, IDataSourceProvider> targetDataSources = new ConcurrentHashMap();
    @Nullable
    private IDataSourceProvider defaultTargetDataSource;
    private Boolean autoCloseSameKeyDataSource = true;
    private IDataSourceProvider currentUsingDataSourceProvider;

    public RoutingDataSource() {
    }

    public RoutingDataSource(IDataSourceProvider defaultTargetDataSource) {
        this();
        this.defaultTargetDataSource = defaultTargetDataSource;
        this.currentUsingDataSourceProvider = defaultTargetDataSource;
    }

    public RoutingDataSource(IDataSourceProvider defaultTargetDataSource, ConcurrentHashMap<Object, IDataSourceProvider> targetDataSources) {
        this(defaultTargetDataSource);
        this.targetDataSources = targetDataSources;
    }

    public void setAutoCloseSameKeyDataSource(Boolean autoCloseSameKeyDataSource) {
        this.autoCloseSameKeyDataSource = autoCloseSameKeyDataSource;
    }

    public Boolean hasDataSource(Object dataSourceKey) {
        Assert.notNull(this.targetDataSources, (String)"[Assertion failed] - the targetDataSources argument cannot be null");
        return this.targetDataSources.containsKey(dataSourceKey);
    }

    public void addDataSource(Object dataSourceKey, IDataSourceProvider dataSource) {
        Assert.notNull(this.targetDataSources, (String)"[Assertion failed] - the targetDataSources argument cannot be null");
        Assert.notNull((Object)dataSourceKey, (String)"[Assertion failed] - the dataSourceKey argument cannot be null");
        Assert.notNull((Object)dataSource, (String)"[Assertion failed] - the dataSource argument cannot be null");
        if (this.hasDataSource(dataSourceKey).booleanValue()) {
            log.info("The dataSource with the same key \"{}\" is exists.", dataSourceKey);
            Assert.isTrue((boolean)this.autoCloseSameKeyDataSource, (String)("the dataSource [" + dataSourceKey + "] with the same key that is exists. you can set the 'autoCloseSameKeyDataSource' to true to auto close the same dataSource."));
            IDataSourceProvider closingDataSource = this.targetDataSources.get(dataSourceKey);
            if (closingDataSource.destroy()) {
                log.info("The dataSource with the key \"{}\" is closed", dataSourceKey);
                this.targetDataSources.remove(dataSourceKey);
            } else {
                log.error("The dataSource with the key \"{}\" has an error in close operations", dataSourceKey);
            }
        }
        this.targetDataSources.put(dataSourceKey, dataSource);
        log.info("The dataSource with the key \"{} \" is added.", dataSourceKey);
    }

    public void addDataSources(Map<Object, IDataSourceProvider> dataSources) {
        if (ValidateKit.isNull(dataSources)) {
            return;
        }
        for (Map.Entry<Object, IDataSourceProvider> entry : dataSources.entrySet()) {
            this.addDataSource(entry.getKey(), entry.getValue());
        }
        log.info("All dataSources being added have been successfully added.");
    }

    public void removeDataSource(Object dataSourceKey) {
        Assert.notNull(this.targetDataSources, (String)"[Assertion failed] - the targetDataSources argument cannot be null");
        if (this.hasDataSource(dataSourceKey).booleanValue()) {
            IDataSourceProvider deletingDataSource = this.targetDataSources.remove(dataSourceKey);
            if (ValidateKit.isNotNull((Object)deletingDataSource)) {
                deletingDataSource.destroy();
            }
            log.info("The dataSource with the key \"{}\" is removed.", dataSourceKey);
        }
    }

    @PreDestroy
    public void preDestroy() {
        if (ValidateKit.isNotNull(this.targetDataSources)) {
            for (Map.Entry<Object, IDataSourceProvider> entry : this.targetDataSources.entrySet()) {
                entry.getValue().destroy();
                log.info("The dataSource with the key \"{}\" is closed.", entry.getKey());
            }
            this.targetDataSources.clear();
        }
    }

    public void setTargetDataSources(ConcurrentHashMap<Object, IDataSourceProvider> targetDataSources) {
        this.targetDataSources = targetDataSources;
    }

    public void setDefaultTargetDataSource(IDataSourceProvider defaultTargetDataSource) {
        this.defaultTargetDataSource = defaultTargetDataSource;
    }

    public void afterPropertiesSet() {
        if (this.defaultTargetDataSource == null) {
            throw new IllegalArgumentException("Property 'defaultTargetDataSource' is required");
        }
        if (this.targetDataSources == null) {
            throw new IllegalArgumentException("Property 'targetDataSources' is required");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    protected DataSource determineTargetDataSource() {
        Assert.notNull(this.targetDataSources, (String)"DataSource router not initialized");
        IDataSourceProvider dataSourceProvider = this.defaultTargetDataSource;
        Object lookupKey = this.determineCurrentLookupKey();
        if (lookupKey != null) {
            dataSourceProvider = this.targetDataSources.get(lookupKey);
        }
        if (dataSourceProvider == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        this.currentUsingDataSourceProvider = dataSourceProvider;
        return dataSourceProvider.getDataSource();
    }

    @Nullable
    protected Object determineCurrentLookupKey() {
        return RoutingDataSourceHolder.getCurrentUsingDataSourceKey();
    }

    public IDataSourceProvider getCurrentUsingDataSourceProvider() {
        return this.currentUsingDataSourceProvider;
    }
}

