/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.datasource.holder;

import org.openingo.java.lang.ThreadLocalX;
import org.openingo.jdkits.validate.ValidateKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoutingDataSourceHolder {
    private static final Logger log = LoggerFactory.getLogger(RoutingDataSourceHolder.class);
    private static final ThreadLocalX<Object> ROUTING_DATASOURCE_HOLDER = new ThreadLocalX();

    private RoutingDataSourceHolder() {
    }

    public static void setCurrentUsingDataSourceKey(Object dataSourceKey) {
        log.info("The key for current setting dataSource is \"{}\"", dataSourceKey);
        ROUTING_DATASOURCE_HOLDER.set(dataSourceKey);
    }

    public static Object getCurrentUsingDataSourceKey() {
        Object usingDataSourceKey = ROUTING_DATASOURCE_HOLDER.get();
        String extMessage = ValidateKit.isNull((Object)usingDataSourceKey) ? ", that will use the default dataSource" : "";
        log.info("The key for current using dataSource is \"{}\"{}.", usingDataSourceKey, (Object)extMessage);
        return usingDataSourceKey;
    }

    public static void clearCurrentUsingDataSourceKey() {
        Object removingDataSourceKey = ROUTING_DATASOURCE_HOLDER.get();
        log.info("The key for current removing dataSource is \"{}\"", removingDataSourceKey);
        ROUTING_DATASOURCE_HOLDER.remove();
    }
}

