/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.spring.boot.extension.data.redis.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.openingo.jdkits.validate.ValidateKit;
import org.openingo.spring.boot.extension.data.redis.serializer.ISerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class FstRedisSerializer<T>
implements ISerializer<T> {
    public static FstRedisSerializer<String> string = new FstRedisSerializer();
    public static FstRedisSerializer<Object> object = new FstRedisSerializer();

    public byte[] serialize(T t) throws SerializationException {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            FSTObjectOutput fstOut = new FSTObjectOutput((OutputStream)bytesOut);
            fstOut.writeObject(t);
            fstOut.flush();
            return bytesOut.toByteArray();
        }
        catch (Exception e) {
            throw new SerializationException(e.toString(), (Throwable)e);
        }
    }

    public T deserialize(byte[] bytes) throws SerializationException {
        if (ValidateKit.isNull((Object)bytes)) {
            return null;
        }
        try {
            FSTObjectInput fstInput = new FSTObjectInput((InputStream)new ByteArrayInputStream(bytes));
            return (T)fstInput.readObject();
        }
        catch (Exception e) {
            throw new SerializationException(e.toString(), (Throwable)e);
        }
    }
}

