/*
 * MIT License
 *
 * Copyright (c) 2021 OpeningO Co.,Ltd.
 *
 *    https://openingo.org
 *    contactus(at)openingo.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.openingo.boot.redip.configuration;

import org.openingo.redip.configuration.RemoteConfiguration;
import org.openingo.redip.dictionary.remote.MySQLRemoteDictionary;
import org.openingo.redip.dictionary.remote.RedisRemoteDictionary;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * RedipAutoConfiguration
 *
 * @author Qicz
 * @since 2021/7/15 10:08
 */
@Configuration
@Import({ RemoteDictionaryConfiguration.class })
public class RedipAutoConfiguration {

	protected final static String CONFIGURATION_PROPERTIES_PREFIX = "openingo.redip";

	@Bean
	@ConfigurationProperties(prefix = RedipAutoConfiguration.CONFIGURATION_PROPERTIES_PREFIX)
	RemoteConfiguration remoteConfiguration() {
		return new RemoteConfiguration();
	}

	@Bean(destroyMethod = "closeResource")
	public MySQLRemoteDictionary mysqlRemoteDictionary(RemoteConfiguration remoteConfiguration) {
		return new MySQLRemoteDictionary(remoteConfiguration);
	}

	@Bean(destroyMethod = "closeResource")
	public RedisRemoteDictionary redisRemoteDictionary(RemoteConfiguration remoteConfiguration) {
		return new RedisRemoteDictionary(remoteConfiguration);
	}
}
