/*
 * Decompiled with CFR 0.152.
 */
package org.openingo.boot.es.ik.redict.dictionary;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.openingo.boot.es.ik.redict.configuration.RemoteDictionaryConfigurationProperties;
import org.openingo.boot.es.ik.redict.dictionary.AbstractRemoteDictionary;
import org.openingo.boot.es.ik.redict.dictionary.DictionaryType;
import org.openingo.jdkits.sys.SystemClockKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLRemoteDictionary
extends AbstractRemoteDictionary {
    private static final Logger log = LoggerFactory.getLogger(MySQLRemoteDictionary.class);
    private final HikariDataSource dataSource = this.initDataSource();

    public MySQLRemoteDictionary(RemoteDictionaryConfigurationProperties properties) {
        super(properties);
    }

    @Override
    protected boolean addWord(String domain, DictionaryType dictionaryType, String word) {
        log.info("'{}' remote dictionary add new word '{}' for dictionary '{}'", new Object[]{this.etymology(), word, dictionaryType});
        boolean ret = true;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            String sql = "INSERT INTO ik_words(word, word_type, domain, create_time) VALUES (?, ?, ?, ?)";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, word);
                statement.setInt(2, dictionaryType.type);
                statement.setString(3, domain);
                statement.setDate(4, new Date(SystemClockKit.now()));
                statement.execute();
                sql = String.format("UPDATE ik_dict_state SET state = 'true' WHERE domain = '%s'", domain);
                statement.execute(sql);
            }
            catch (SQLException e) {
                connection.rollback();
                connection.setAutoCommit(true);
                throw e;
            }
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error("'{} add new word '{}' failure '{}'.", new Object[]{this.etymology(), word, e});
            ret = false;
        }
        return ret;
    }

    @Override
    protected void closeResource() {
        String etymology = this.etymology();
        log.info("'{}' remote dictionary is closing...", (Object)etymology);
        this.dataSource.close();
        log.info("'{}' remote dictionary is closed", (Object)etymology);
    }

    @Override
    protected String etymology() {
        return "mysql";
    }

    private HikariDataSource initDataSource() {
        HikariDataSource dataSource = new HikariDataSource();
        RemoteDictionaryConfigurationProperties.MySQL mysql = this.properties.getMysql();
        dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        dataSource.setJdbcUrl(mysql.getUrl());
        dataSource.setUsername(mysql.getUsername());
        dataSource.setPassword(mysql.getPassword());
        return dataSource;
    }
}

