package org.openingo.boot.es.ik.redict.dictionary;

import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.openingo.boot.es.ik.redict.configuration.RemoteDictionaryConfigurationProperties;
import org.openingo.jdkits.sys.SystemClockKit;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * MySQLRemoteDictionary
 *
 * @author Qicz
 * @since 2021/7/14 18:48
 */
@Slf4j
public class MySQLRemoteDictionary extends AbstractRemoteDictionary {

	private final HikariDataSource dataSource;

	public MySQLRemoteDictionary(RemoteDictionaryConfigurationProperties properties) {
		super(properties);
		this.dataSource = this.initDataSource();
	}

	@Override
	protected boolean addWord(String domain, DictionaryType dictionaryType, String word) {
		log.info("'{}' remote dictionary add new word '{}' for dictionary '{}'", this.etymology(), word, dictionaryType);
		boolean ret = true;
		try (Connection connection = this.dataSource.getConnection()) {
			connection.setAutoCommit(false);
			String sql = "INSERT INTO ik_words(word, word_type, domain, create_time) VALUES (?, ?, ?, ?)";
			try (PreparedStatement statement = connection.prepareStatement(sql)) {
				statement.setString(1, word);
				statement.setInt(2, dictionaryType.type);
				statement.setString(3, domain);
				statement.setDate(4, new Date(SystemClockKit.now()));
				// add word
				statement.execute();
				// update state
				sql = String.format("UPDATE ik_dict_state SET state = 'true' WHERE domain = '%s'", domain);
				statement.execute(sql);
			} catch (SQLException e) {
				connection.rollback();
				connection.setAutoCommit(true);
				throw e;
			}
			connection.commit();
			connection.setAutoCommit(true);
		} catch (SQLException e) {
			e.printStackTrace();
			log.error("'{} add new word '{}' failure '{}'.", this.etymology(), word, e);
			ret = false;
		}
		return ret;
	}

	@Override
	protected void closeResource() {
		String etymology = this.etymology();
		log.info("'{}' remote dictionary is closing...", etymology);
		this.dataSource.close();
		log.info("'{}' remote dictionary is closed", etymology);
	}

	@Override
	protected String etymology() {
		return "mysql";
	}

	private HikariDataSource initDataSource() {
		HikariDataSource dataSource = new HikariDataSource();
		RemoteDictionaryConfigurationProperties.MySQL mysql = this.properties.getMysql();
		dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
		dataSource.setJdbcUrl(mysql.getUrl());
		dataSource.setUsername(mysql.getUsername());
		dataSource.setPassword(mysql.getPassword());
		return dataSource;
	}
}
