package org.openingo.boot.es.ik.redict.dictionary;

import org.openingo.boot.es.ik.redict.configuration.RemoteDictionaryConfigurationProperties;

/**
 * AbstractRemoteDictionary
 *
 * @author Qicz
 * @since 2021/7/14 18:49
 */
abstract class AbstractRemoteDictionary {

	protected final RemoteDictionaryConfigurationProperties properties;

	AbstractRemoteDictionary(RemoteDictionaryConfigurationProperties properties) {
		this.properties = properties;
	}

	/**
	 * 添加一个主词
	 * @param domain 业务
	 * @param word 新词
	 * @return true成功
	 */
	public boolean addMainWord(String domain, String word) {
		return addWord(domain, DictionaryType.MAIN_WORDS, word);
	}

	/**
	 * 添加一个stop词
	 * @param domain 业务
	 * @param word 新词
	 * @return true成功
	 */
	public boolean addStopWord(String domain, String word) {
		return addWord(domain, DictionaryType.STOP_WORDS, word);
	}

	/**
	 * 添加一个新词
	 * @param domain 业务
	 * @param dictionaryType 词典类型
	 * @param word 新词
	 * @return true成功
	 */
	protected abstract boolean addWord(String domain, DictionaryType dictionaryType, String word);

	/**
	 * close resources
	 */
	protected abstract void closeResource();

	/**
	 * 词典词源
	 */
	protected abstract String etymology();
}
