package org.openingo.boot.es.ik.redict.configuration;

import lombok.Data;
import org.openingo.boot.es.ik.redict.constants.Constants;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * RemoteDictionaryConfigurationProperties
 *
 * @author Qicz
 * @since 2021/7/14 18:32
 */
@Data
@ConfigurationProperties(prefix = Constants.CONFIGURATION_PROPERTIES_PREFIX)
public class RemoteDictionaryConfigurationProperties {

	/**
	 * mysql 配置
	 */
	MySQL mysql = new MySQL();

	/**
	 * redis 配置
	 */
	Redis redis = new Redis();

	@Data
	public static class MySQL {
		private String url;
		private String username;
		private String password;
	}

	@Data
	public static class Redis {

		private String host = "localhost";
		private Integer port = 6379;
		private String username;
		private String password;
		private Integer database = 0;
	}
}
