package org.openingo.boot.es.ik.redict.configuration;

import org.openingo.boot.es.ik.redict.dictionary.MySQLRemoteDictionary;
import org.openingo.boot.es.ik.redict.dictionary.RedisRemoteDictionary;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * RemoteDictionaryConfiguration
 *
 * @author Qicz
 * @since 2021/7/14 18:30
 */
@Configuration
@EnableConfigurationProperties(RemoteDictionaryConfigurationProperties.class)
public class RemoteDictionaryConfiguration {

	@Bean(destroyMethod = "closeResource")
	public MySQLRemoteDictionary mysqlRemoteDictionary(RemoteDictionaryConfigurationProperties properties) {
		return new MySQLRemoteDictionary(properties);
	}

	@Bean(destroyMethod = "closeResource")
	public RedisRemoteDictionary redisRemoteDictionary(RemoteDictionaryConfigurationProperties properties) {
		return new RedisRemoteDictionary(properties);
	}
}
