/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hardware.compass;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openimaj.hardware.compass.CompassData;

public class OS5000_0x01_Parser {
    private static final Pattern COMPASS = Pattern.compile("C(\\d+\\.\\d+)");
    private static final Pattern PITCH = Pattern.compile("P(-??\\d+\\.\\d+)");
    private static final Pattern ROLL = Pattern.compile("R(-??\\d+\\.\\d+)");
    private static final Pattern TEMPERATURE = Pattern.compile("T(-??\\d+\\.\\d+)");
    private static final Pattern MX = Pattern.compile("Mx(-??\\d+\\.\\d+)");
    private static final Pattern MY = Pattern.compile("My(-??\\d+\\.\\d+)");
    private static final Pattern MZ = Pattern.compile("Mz(-??\\d+\\.\\d+)");
    private static final Pattern AX = Pattern.compile("Ax(-??\\d+\\.\\d+)");
    private static final Pattern AY = Pattern.compile("Ay(-??\\d+\\.\\d+)");
    private static final Pattern AZ = Pattern.compile("Az(-??\\d+\\.\\d+)");

    public static CompassData parseLine(String line) {
        CompassData data = new CompassData();
        data.compass = OS5000_0x01_Parser.parse(COMPASS, line);
        data.pitch = OS5000_0x01_Parser.parse(PITCH, line);
        data.roll = OS5000_0x01_Parser.parse(ROLL, line);
        data.temperature = OS5000_0x01_Parser.parse(TEMPERATURE, line);
        data.mx = OS5000_0x01_Parser.parse(MX, line);
        data.my = OS5000_0x01_Parser.parse(MY, line);
        data.mz = OS5000_0x01_Parser.parse(MZ, line);
        data.ax = OS5000_0x01_Parser.parse(AX, line);
        data.ay = OS5000_0x01_Parser.parse(AY, line);
        data.az = OS5000_0x01_Parser.parse(AZ, line);
        return data;
    }

    private static double parse(Pattern p, String line) {
        Matcher m = p.matcher(line);
        if (m.find()) {
            return Double.parseDouble(m.group(1));
        }
        return 0.0;
    }
}

