/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hardware.compass;

import org.openimaj.hardware.compass.CompassData;
import org.openimaj.hardware.compass.OS5000_0x01_Parser;
import org.openimaj.hardware.serial.SerialDataListener;
import org.openimaj.hardware.serial.SerialDevice;

public class CompassSerialReader
implements Runnable {
    private String portName = null;
    private CompassData latestData = null;

    public CompassSerialReader(String portName) {
        this.portName = portName;
    }

    @Override
    public void run() {
        try {
            String firstPort = this.portName;
            System.out.println("Opening " + firstPort);
            SerialDevice sd = new SerialDevice(firstPort, 19200, 8, 1, 0);
            sd.addSerialDataListener(new SerialDataListener(){

                public void dataReceived(String data) {
                    CompassSerialReader.this.latestData = OS5000_0x01_Parser.parseLine(data.trim());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompassData getCompassData() {
        return this.latestData;
    }

    public static void main(String[] args) {
        new CompassSerialReader("/dev/ttyUSB0").run();
    }
}

