/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.slideshow;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import org.apache.commons.lang.SystemUtils;

public class FullscreenUtility {
    protected JFrame window;
    protected boolean fullscreen = false;

    public FullscreenUtility(JFrame frame) {
        this.window = frame;
        if (SystemUtils.IS_OS_MAC_OSX) {
            try {
                Class<?> util = Class.forName("com.apple.eawt.FullScreenUtilities");
                Class[] params = new Class[]{Window.class, Boolean.TYPE};
                Method method = util.getMethod("setWindowCanFullScreen", params);
                method.invoke(util, this.window, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setFullscreen(boolean fullscreen) {
        if (this.fullscreen != fullscreen) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                this.setFullscreenOSX(fullscreen);
            } else {
                this.setFullscreenAWT(fullscreen);
            }
        }
    }

    private void setFullscreenOSX(boolean fullscreen) {
        this.fullscreen = fullscreen;
        try {
            Class<?> appClz = Class.forName("com.apple.eawt.Application");
            Method getApp = appClz.getMethod("getApplication", new Class[0]);
            Object app = getApp.invoke(appClz, new Object[0]);
            Class[] params = new Class[]{Window.class};
            Method reqFS = appClz.getMethod("requestToggleFullScreen", params);
            reqFS.invoke(app, this.window);
        }
        catch (ClassNotFoundException appClz) {
        }
        catch (Exception e) {
            this.fullscreen = !fullscreen;
            this.setFullscreenAWT(fullscreen);
        }
    }

    private void setFullscreenAWT(boolean fullscreen) {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.fullscreen = fullscreen;
        if (!fullscreen) {
            this.window.setVisible(false);
            this.window.dispose();
            this.window.setUndecorated(false);
            device.setFullScreenWindow(null);
            this.window.setLocationRelativeTo(null);
            this.window.setResizable(true);
            this.window.setVisible(true);
        } else {
            this.window.setVisible(false);
            this.window.dispose();
            this.window.setUndecorated(true);
            this.window.setResizable(false);
            this.window.setAlwaysOnTop(false);
            device.setFullScreenWindow(this.window);
            if (SystemUtils.IS_JAVA_1_7 && SystemUtils.IS_OS_MAC_OSX) {
                System.err.println("Applying first responder fix");
                this.window.setVisible(false);
            }
            this.window.setVisible(true);
        }
        this.window.repaint();
    }
}

