/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.slideshow;

import Jama.Matrix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.openimaj.content.slideshow.PictureSlide;
import org.openimaj.content.slideshow.Slide;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processing.transform.MBFProjectionProcessor;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.VideoDisplayListener;
import org.openimaj.video.xuggle.XuggleVideo;

public class VideoSlide
implements Slide,
VideoDisplayListener<MBFImage>,
KeyListener {
    URL url;
    VideoDisplay<MBFImage> display;
    private URL background;
    protected PictureSlide pictureSlide;
    private final Matrix transform;
    private DisplayUtilities.ImageComponent panel;
    private BufferedImage bimg;
    private MBFImage mbfImage;
    private XuggleVideo video;
    private VideoDisplay.EndAction endAction = VideoDisplay.EndAction.LOOP;

    public VideoSlide(URL video, URL background, Matrix transform, VideoDisplay.EndAction endAction) throws IOException {
        this.url = this.makeURL(video);
        this.background = background;
        this.pictureSlide = new PictureSlide(this.background);
        this.transform = transform;
        this.endAction = endAction;
    }

    public VideoSlide(URL video, Matrix transform, VideoDisplay.EndAction endAction) throws IOException {
        this.url = this.makeURL(video);
        this.transform = transform;
        this.endAction = endAction;
    }

    private URL makeURL(URL url) throws IOException {
        if (url.getProtocol().startsWith("jar")) {
            File tmp = File.createTempFile("movie", ".tmp");
            tmp.deleteOnExit();
            FileUtils.copyURLToFile((URL)url, (File)tmp);
            url = tmp.toURI().toURL();
        }
        return url;
    }

    public VideoSlide(URL video, URL background, VideoDisplay.EndAction endAction) throws IOException {
        this(video, background, null, endAction);
    }

    @Override
    public Component getComponent(int width, int height) throws IOException {
        if (this.pictureSlide == null) {
            this.mbfImage = new MBFImage(width, height, 3);
            this.panel = (DisplayUtilities.ImageComponent)new PictureSlide(this.mbfImage).getComponent(width, height);
        } else {
            this.panel = (DisplayUtilities.ImageComponent)this.pictureSlide.getComponent(width, height);
            this.mbfImage = (MBFImage)this.pictureSlide.mbfImage.clone();
        }
        this.panel.setSize(width, height);
        this.panel.setPreferredSize(new Dimension(width, height));
        this.video = new XuggleVideo(this.url, false);
        this.display = VideoDisplay.createOffscreenVideoDisplay((Video)this.video);
        this.display.setEndAction(this.endAction);
        this.display.addVideoListener((VideoDisplayListener)this);
        return this.panel;
    }

    @Override
    public void close() {
        this.display.close();
    }

    public void afterUpdate(VideoDisplay<MBFImage> display) {
    }

    public void beforeUpdate(MBFImage frame) {
        if (this.transform != null) {
            MBFImage bgCopy = (MBFImage)this.mbfImage.clone();
            MBFProjectionProcessor proj = new MBFProjectionProcessor();
            proj.setMatrix(this.transform);
            proj.accumulate((Image)frame);
            proj.performProjection(0, 0, bgCopy);
            this.bimg = ImageUtilities.createBufferedImageForDisplay((MBFImage)bgCopy, (BufferedImage)this.bimg);
            this.panel.setImage(this.bimg);
        } else {
            this.bimg = ImageUtilities.createBufferedImageForDisplay((MBFImage)frame, (BufferedImage)this.bimg);
            this.panel.setImage(this.bimg);
        }
    }

    @Override
    public void keyPressed(KeyEvent key) {
        int code = key.getKeyCode();
        if (code >= 48 && code <= 57) {
            double prop = (double)(code - 48) / 10.0;
            long dur = this.video.getDuration();
            this.display.seek((long)((double)dur * prop));
        }
        if (code == 32) {
            this.display.togglePause();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

