/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.slideshow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import org.openimaj.content.slideshow.Slide;

public abstract class Slideshow
implements KeyListener {
    protected RootPaneContainer container;
    protected List<Slide> slides;
    protected int currentSlideIndex = -1;
    protected Component currentSlideComp;
    protected int slideWidth;
    protected int slideHeight;
    protected Slide currentSlide;
    private JPanel contentPanel;

    public Slideshow(RootPaneContainer container, List<Slide> slides, final int slideWidth, final int slideHeight, BufferedImage background) throws IOException {
        BufferedImage bg;
        this.container = container;
        this.slideWidth = slideWidth;
        this.slideHeight = slideHeight;
        if (background == null) {
            bg = new BufferedImage(slideWidth, slideHeight, 5);
            Graphics2D g = bg.createGraphics();
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(0, 0, bg.getWidth(), bg.getHeight());
        } else {
            bg = background;
        }
        this.contentPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(bg, 0, 0, slideWidth, slideHeight, null);
            }
        };
        this.contentPanel.setOpaque(false);
        this.contentPanel.setSize(slideWidth, slideHeight);
        this.contentPanel.setPreferredSize(new Dimension(slideWidth, slideHeight));
        this.contentPanel.setLayout(new GridBagLayout());
        JPanel scrollContent = new JPanel();
        scrollContent.setLayout(new GridBagLayout());
        scrollContent.setSize(this.contentPanel.getSize());
        scrollContent.setPreferredSize(this.contentPanel.getSize());
        scrollContent.add(this.contentPanel);
        scrollContent.setBackground(Color.BLACK);
        container.getContentPane().setBackground(Color.BLACK);
        JScrollPane scroller = new JScrollPane(scrollContent);
        scroller.setBackground(Color.BLACK);
        scroller.setBorder(null);
        container.getContentPane().add((Component)scroller, "Center");
        ((Component)((Object)container)).addKeyListener(this);
        this.slides = slides;
        this.displayNextSlide();
        this.pack();
        ((Component)((Object)container)).setVisible(true);
    }

    protected abstract void pack();

    public void displayNextSlide() throws IOException {
        if (this.currentSlideIndex < this.slides.size() - 1) {
            ++this.currentSlideIndex;
            this.displaySlide(this.slides.get(this.currentSlideIndex));
        }
    }

    public void displayPrevSlide() throws IOException {
        if (this.currentSlideIndex > 0) {
            --this.currentSlideIndex;
            this.displaySlide(this.slides.get(this.currentSlideIndex));
        }
    }

    protected void displaySlide(Slide slide) throws IOException {
        if (this.currentSlideComp != null) {
            this.contentPanel.remove(this.currentSlideComp);
            this.currentSlide.close();
        }
        this.currentSlide = slide;
        this.currentSlideComp = this.currentSlide.getComponent(this.slideWidth, this.slideHeight);
        this.currentSlideComp.setPreferredSize(new Dimension(this.slideWidth, this.slideHeight));
        this.currentSlideComp.setMaximumSize(new Dimension(this.slideWidth, this.slideHeight));
        this.contentPanel.add(this.currentSlideComp, new GridBagConstraints());
        this.currentSlideComp.setFocusable(true);
        this.currentSlideComp.requestFocus();
        this.currentSlideComp.addKeyListener(this);
        this.currentSlideComp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Slideshow.this.currentSlideComp.requestFocus();
            }
        });
        this.contentPanel.validate();
        ((Component)((Object)this.container)).repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.currentSlide instanceof KeyListener) {
            ((KeyListener)((Object)this.currentSlide)).keyTyped(e);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        try {
            switch (e.getKeyCode()) {
                case 37: {
                    this.displayPrevSlide();
                    break;
                }
                case 39: {
                    this.displayNextSlide();
                    break;
                }
                case 70: {
                    this.toggleFullscreen();
                    break;
                }
                case 27: {
                    this.setFullscreen(false);
                    break;
                }
                case 81: {
                    System.exit(0);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.currentSlide instanceof KeyListener) {
            ((KeyListener)((Object)this.currentSlide)).keyPressed(e);
        }
    }

    private void toggleFullscreen() {
        this.setFullscreen(!this.isFullscreen());
    }

    protected abstract boolean isFullscreen();

    public abstract void setFullscreen(boolean var1);

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.currentSlide instanceof KeyListener) {
            ((KeyListener)((Object)this.currentSlide)).keyReleased(e);
        }
    }
}

