/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.slideshow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.openimaj.content.slideshow.Slide;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;

public class PictureSlide
implements Slide {
    protected URL url;
    protected DisplayUtilities.ScalingImageComponent ic;
    protected MBFImage mbfImage;

    public PictureSlide(URL picture) throws IOException {
        this.url = picture;
        this.mbfImage = ImageUtilities.readMBF((URL)this.url);
    }

    public PictureSlide(MBFImage mbfImage) {
        this.mbfImage = mbfImage;
    }

    @Override
    public Component getComponent(int width, int height) throws IOException {
        BufferedImage image = ImageUtilities.createBufferedImageForDisplay((MBFImage)this.mbfImage, null);
        this.ic = new DisplayUtilities.ScalingImageComponent();
        this.ic.setImage(image);
        this.ic.setSize(width, height);
        this.ic.setPreferredSize(new Dimension(width, height));
        this.ic.setShowPixelColours(false);
        this.ic.setShowXYPosition(false);
        this.ic.removeMouseListener((MouseListener)this.ic);
        this.ic.removeMouseMotionListener((MouseMotionListener)this.ic);
        return this.ic;
    }

    @Override
    public void close() {
        this.ic = null;
    }
}

